/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIAgentVersionSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse;

public class ListAIAgentVersionsPublisher
implements SdkPublisher<ListAiAgentVersionsResponse> {
    private final QConnectAsyncClient client;
    private final ListAiAgentVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAIAgentVersionsPublisher(QConnectAsyncClient client, ListAiAgentVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAIAgentVersionsPublisher(QConnectAsyncClient client, ListAiAgentVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAiAgentVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAiAgentVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AIAgentVersionSummary> aiAgentVersionSummaries() {
        Function<ListAiAgentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiAgentVersionSummaries() != null) {
                return response.aiAgentVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAiAgentVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAiAgentVersionsResponseFetcher
    implements AsyncPageFetcher<ListAiAgentVersionsResponse> {
        private ListAiAgentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiAgentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAiAgentVersionsResponse> nextPage(ListAiAgentVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAIAgentVersionsPublisher.this.client.listAIAgentVersions(ListAIAgentVersionsPublisher.this.firstRequest);
            }
            return ListAIAgentVersionsPublisher.this.client.listAIAgentVersions((ListAiAgentVersionsRequest)((Object)ListAIAgentVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

