/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIPromptVersionSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiPromptVersionsResponse;

public class ListAIPromptVersionsPublisher
implements SdkPublisher<ListAiPromptVersionsResponse> {
    private final QConnectAsyncClient client;
    private final ListAiPromptVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAIPromptVersionsPublisher(QConnectAsyncClient client, ListAiPromptVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAIPromptVersionsPublisher(QConnectAsyncClient client, ListAiPromptVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAiPromptVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAiPromptVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AIPromptVersionSummary> aiPromptVersionSummaries() {
        Function<ListAiPromptVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiPromptVersionSummaries() != null) {
                return response.aiPromptVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAiPromptVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAiPromptVersionsResponseFetcher
    implements AsyncPageFetcher<ListAiPromptVersionsResponse> {
        private ListAiPromptVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiPromptVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAiPromptVersionsResponse> nextPage(ListAiPromptVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAIPromptVersionsPublisher.this.client.listAIPromptVersions(ListAIPromptVersionsPublisher.this.firstRequest);
            }
            return ListAIPromptVersionsPublisher.this.client.listAIPromptVersions((ListAiPromptVersionsRequest)((Object)ListAIPromptVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

