/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.internal.UserAgentUtils;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse;

public class ListResourceSharePermissionsIterable
implements SdkIterable<ListResourceSharePermissionsResponse> {
    private final RamClient client;
    private final ListResourceSharePermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceSharePermissionsIterable(RamClient client, ListResourceSharePermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceSharePermissionsResponseFetcher();
    }

    public Iterator<ListResourceSharePermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListResourceSharePermissionsResponseFetcher
    implements SyncPageFetcher<ListResourceSharePermissionsResponse> {
        private ListResourceSharePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceSharePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceSharePermissionsResponse nextPage(ListResourceSharePermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceSharePermissionsIterable.this.client.listResourceSharePermissions(ListResourceSharePermissionsIterable.this.firstRequest);
            }
            return ListResourceSharePermissionsIterable.this.client.listResourceSharePermissions((ListResourceSharePermissionsRequest)((Object)ListResourceSharePermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

