/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.DbGroupListCopier;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchExecuteStatementResponse
extends RedshiftDataResponse
implements ToCopyableBuilder<Builder, BatchExecuteStatementResponse> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::clusterIdentifier)).setter(BatchExecuteStatementResponse.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::createdAt)).setter(BatchExecuteStatementResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::database)).setter(BatchExecuteStatementResponse.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<List<String>> DB_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DbGroups").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::dbGroups)).setter(BatchExecuteStatementResponse.setter(Builder::dbGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::dbUser)).setter(BatchExecuteStatementResponse.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::id)).setter(BatchExecuteStatementResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::secretArn)).setter(BatchExecuteStatementResponse.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::sessionId)).setter(BatchExecuteStatementResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkgroupName").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::workgroupName)).setter(BatchExecuteStatementResponse.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkgroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, CREATED_AT_FIELD, DATABASE_FIELD, DB_GROUPS_FIELD, DB_USER_FIELD, ID_FIELD, SECRET_ARN_FIELD, SESSION_ID_FIELD, WORKGROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchExecuteStatementResponse.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final Instant createdAt;
    private final String database;
    private final List<String> dbGroups;
    private final String dbUser;
    private final String id;
    private final String secretArn;
    private final String sessionId;
    private final String workgroupName;

    private BatchExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.createdAt = builder.createdAt;
        this.database = builder.database;
        this.dbGroups = builder.dbGroups;
        this.dbUser = builder.dbUser;
        this.id = builder.id;
        this.secretArn = builder.secretArn;
        this.sessionId = builder.sessionId;
        this.workgroupName = builder.workgroupName;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String database() {
        return this.database;
    }

    public final boolean hasDbGroups() {
        return this.dbGroups != null && !(this.dbGroups instanceof SdkAutoConstructList);
    }

    public final List<String> dbGroups() {
        return this.dbGroups;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final String id() {
        return this.id;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbGroups() ? this.dbGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchExecuteStatementResponse)) {
            return false;
        }
        BatchExecuteStatementResponse other = (BatchExecuteStatementResponse)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.database(), other.database()) && this.hasDbGroups() == other.hasDbGroups() && Objects.equals(this.dbGroups(), other.dbGroups()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.workgroupName(), other.workgroupName());
    }

    public final String toString() {
        return ToString.builder((String)"BatchExecuteStatementResponse").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("CreatedAt", (Object)this.createdAt()).add("Database", (Object)this.database()).add("DbGroups", this.hasDbGroups() ? this.dbGroups() : null).add("DbUser", (Object)this.dbUser()).add("Id", (Object)this.id()).add("SecretArn", (Object)this.secretArn()).add("SessionId", (Object)this.sessionId()).add("WorkgroupName", (Object)this.workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "DbGroups": {
                return Optional.ofNullable(clazz.cast(this.dbGroups()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "WorkgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("DbGroups", DB_GROUPS_FIELD);
        map.put("DbUser", DB_USER_FIELD);
        map.put("Id", ID_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("WorkgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchExecuteStatementResponse, T> g) {
        return obj -> g.apply((BatchExecuteStatementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataResponse.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private Instant createdAt;
        private String database;
        private List<String> dbGroups = DefaultSdkAutoConstructList.getInstance();
        private String dbUser;
        private String id;
        private String secretArn;
        private String sessionId;
        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchExecuteStatementResponse model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.createdAt(model.createdAt);
            this.database(model.database);
            this.dbGroups(model.dbGroups);
            this.dbUser(model.dbUser);
            this.id(model.id);
            this.secretArn(model.secretArn);
            this.sessionId(model.sessionId);
            this.workgroupName(model.workgroupName);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final Collection<String> getDbGroups() {
            if (this.dbGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbGroups;
        }

        public final void setDbGroups(Collection<String> dbGroups) {
            this.dbGroups = DbGroupListCopier.copy(dbGroups);
        }

        @Override
        public final Builder dbGroups(Collection<String> dbGroups) {
            this.dbGroups = DbGroupListCopier.copy(dbGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbGroups(String ... dbGroups) {
            this.dbGroups(Arrays.asList(dbGroups));
            return this;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public BatchExecuteStatementResponse build() {
            return new BatchExecuteStatementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchExecuteStatementResponse> {
        public Builder clusterIdentifier(String var1);

        public Builder createdAt(Instant var1);

        public Builder database(String var1);

        public Builder dbGroups(Collection<String> var1);

        public Builder dbGroups(String ... var1);

        public Builder dbUser(String var1);

        public Builder id(String var1);

        public Builder secretArn(String var1);

        public Builder sessionId(String var1);

        public Builder workgroupName(String var1);
    }
}

