/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class IoteventsdataServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "ioteventsdata";
    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().put((Object)"ap-northeast-1", (Object)"data.iotevents.ap-northeast-1.amazonaws.com").put((Object)"ap-northeast-2", (Object)"data.iotevents.ap-northeast-2.amazonaws.com").put((Object)"ap-southeast-1", (Object)"data.iotevents.ap-southeast-1.amazonaws.com").put((Object)"ap-southeast-2", (Object)"data.iotevents.ap-southeast-2.amazonaws.com").put((Object)"eu-central-1", (Object)"data.iotevents.eu-central-1.amazonaws.com").put((Object)"eu-west-1", (Object)"data.iotevents.eu-west-1.amazonaws.com").put((Object)"eu-west-2", (Object)"data.iotevents.eu-west-2.amazonaws.com").put((Object)"us-east-1", (Object)"data.iotevents.us-east-1.amazonaws.com").put((Object)"us-east-2", (Object)"data.iotevents.us-east-2.amazonaws.com").put((Object)"us-west-2", (Object)"data.iotevents.us-west-2.amazonaws.com").put((Object)"cn-north-1", (Object)"data.iotevents.cn-north-1.amazonaws.com.cn").put((Object)"us-gov-west-1", (Object)"data.iotevents.us-gov-west-1.amazonaws.com").build();
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("eu-central-1"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("us-gov-west-1")));
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().put((Object)"ap-northeast-1", (Object)"ap-northeast-1").put((Object)"ap-northeast-2", (Object)"ap-northeast-2").put((Object)"ap-southeast-1", (Object)"ap-southeast-1").put((Object)"ap-southeast-2", (Object)"ap-southeast-2").put((Object)"eu-central-1", (Object)"eu-central-1").put((Object)"eu-west-1", (Object)"eu-west-1").put((Object)"eu-west-2", (Object)"eu-west-2").put((Object)"us-east-1", (Object)"us-east-1").put((Object)"us-east-2", (Object)"us-east-2").put((Object)"us-west-2", (Object)"us-west-2").put((Object)"cn-north-1", (Object)"cn-north-1").put((Object)"us-gov-west-1", (Object)"us-gov-west-1").build();
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null)));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : this.computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}

