/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class KmsServiceMetadata implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "kms";

    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.<String, String> builder().build();

    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.<String, String> builder()
            .put("af-south-1-fips", "kms-fips.af-south-1.amazonaws.com")
            .put("ap-east-1-fips", "kms-fips.ap-east-1.amazonaws.com")
            .put("ap-northeast-1-fips", "kms-fips.ap-northeast-1.amazonaws.com")
            .put("ap-northeast-2-fips", "kms-fips.ap-northeast-2.amazonaws.com")
            .put("ap-northeast-3-fips", "kms-fips.ap-northeast-3.amazonaws.com")
            .put("ap-south-1-fips", "kms-fips.ap-south-1.amazonaws.com")
            .put("ap-southeast-1-fips", "kms-fips.ap-southeast-1.amazonaws.com")
            .put("ap-southeast-2-fips", "kms-fips.ap-southeast-2.amazonaws.com")
            .put("ca-central-1-fips", "kms-fips.ca-central-1.amazonaws.com")
            .put("eu-central-1-fips", "kms-fips.eu-central-1.amazonaws.com")
            .put("eu-north-1-fips", "kms-fips.eu-north-1.amazonaws.com")
            .put("eu-south-1-fips", "kms-fips.eu-south-1.amazonaws.com")
            .put("eu-west-1-fips", "kms-fips.eu-west-1.amazonaws.com").put("eu-west-2-fips", "kms-fips.eu-west-2.amazonaws.com")
            .put("eu-west-3-fips", "kms-fips.eu-west-3.amazonaws.com")
            .put("me-south-1-fips", "kms-fips.me-south-1.amazonaws.com")
            .put("sa-east-1-fips", "kms-fips.sa-east-1.amazonaws.com").put("us-east-1-fips", "kms-fips.us-east-1.amazonaws.com")
            .put("us-east-2-fips", "kms-fips.us-east-2.amazonaws.com").put("us-west-1-fips", "kms-fips.us-west-1.amazonaws.com")
            .put("us-west-2-fips", "kms-fips.us-west-2.amazonaws.com")
            .put("us-iso-east-1-fips", "kms-fips.us-iso-east-1.c2s.ic.gov")
            .put("us-iso-west-1-fips", "kms-fips.us-iso-west-1.c2s.ic.gov")
            .put("us-isob-east-1-fips", "kms-fips.us-isob-east-1.sc2s.sgov.gov")
            .put("us-gov-east-1-fips", "kms-fips.us-gov-east-1.amazonaws.com")
            .put("us-gov-west-1-fips", "kms-fips.us-gov-west-1.amazonaws.com").build();

    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"),
            Region.of("af-south-1-fips"), Region.of("ap-east-1"), Region.of("ap-east-1-fips"), Region.of("ap-northeast-1"),
            Region.of("ap-northeast-1-fips"), Region.of("ap-northeast-2"), Region.of("ap-northeast-2-fips"),
            Region.of("ap-northeast-3"), Region.of("ap-northeast-3-fips"), Region.of("ap-south-1"), Region.of("ap-south-1-fips"),
            Region.of("ap-southeast-1"), Region.of("ap-southeast-1-fips"), Region.of("ap-southeast-2"),
            Region.of("ap-southeast-2-fips"), Region.of("ca-central-1"), Region.of("ca-central-1-fips"),
            Region.of("eu-central-1"), Region.of("eu-central-1-fips"), Region.of("eu-north-1"), Region.of("eu-north-1-fips"),
            Region.of("eu-south-1"), Region.of("eu-south-1-fips"), Region.of("eu-west-1"), Region.of("eu-west-1-fips"),
            Region.of("eu-west-2"), Region.of("eu-west-2-fips"), Region.of("eu-west-3"), Region.of("eu-west-3-fips"),
            Region.of("me-south-1"), Region.of("me-south-1-fips"), Region.of("sa-east-1"), Region.of("sa-east-1-fips"),
            Region.of("us-east-1"), Region.of("us-east-1-fips"), Region.of("us-east-2"), Region.of("us-east-2-fips"),
            Region.of("us-west-1"), Region.of("us-west-1-fips"), Region.of("us-west-2"), Region.of("us-west-2-fips"),
            Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("us-gov-east-1"), Region.of("us-gov-east-1-fips"),
            Region.of("us-gov-west-1"), Region.of("us-gov-west-1-fips"), Region.of("us-iso-east-1"),
            Region.of("us-iso-east-1-fips"), Region.of("us-iso-west-1"), Region.of("us-iso-west-1-fips"),
            Region.of("us-isob-east-1"), Region.of("us-isob-east-1-fips")));

    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.<String, String> builder()
            .put("af-south-1-fips", "af-south-1").put("ap-east-1-fips", "ap-east-1").put("ap-northeast-1-fips", "ap-northeast-1")
            .put("ap-northeast-2-fips", "ap-northeast-2").put("ap-northeast-3-fips", "ap-northeast-3")
            .put("ap-south-1-fips", "ap-south-1").put("ap-southeast-1-fips", "ap-southeast-1")
            .put("ap-southeast-2-fips", "ap-southeast-2").put("ca-central-1-fips", "ca-central-1")
            .put("eu-central-1-fips", "eu-central-1").put("eu-north-1-fips", "eu-north-1").put("eu-south-1-fips", "eu-south-1")
            .put("eu-west-1-fips", "eu-west-1").put("eu-west-2-fips", "eu-west-2").put("eu-west-3-fips", "eu-west-3")
            .put("me-south-1-fips", "me-south-1").put("sa-east-1-fips", "sa-east-1").put("us-east-1-fips", "us-east-1")
            .put("us-east-2-fips", "us-east-2").put("us-west-1-fips", "us-west-1").put("us-west-2-fips", "us-west-2")
            .put("us-iso-east-1-fips", "us-iso-east-1").put("us-iso-west-1-fips", "us-iso-west-1")
            .put("us-isob-east-1-fips", "us-isob-east-1").put("us-gov-east-1-fips", "us-gov-east-1")
            .put("us-gov-west-1-fips", "us-gov-west-1").build();

    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(
            new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null),
            new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null),
            new DefaultServicePartitionMetadata("aws-iso-b", null)));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id())
                : computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}
