/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.CelebrityRecognition;
import software.amazon.awssdk.services.rekognition.model.CelebrityRecognitionsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.Video;
import software.amazon.awssdk.services.rekognition.model.VideoJobStatus;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCelebrityRecognitionResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetCelebrityRecognitionResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(GetCelebrityRecognitionResponse.getter(GetCelebrityRecognitionResponse::jobStatusAsString)).setter(GetCelebrityRecognitionResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetCelebrityRecognitionResponse.getter(GetCelebrityRecognitionResponse::statusMessage)).setter(GetCelebrityRecognitionResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoMetadata").getter(GetCelebrityRecognitionResponse.getter(GetCelebrityRecognitionResponse::videoMetadata)).setter(GetCelebrityRecognitionResponse.setter(Builder::videoMetadata)).constructor(VideoMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCelebrityRecognitionResponse.getter(GetCelebrityRecognitionResponse::nextToken)).setter(GetCelebrityRecognitionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<CelebrityRecognition>> CELEBRITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Celebrities").getter(GetCelebrityRecognitionResponse.getter(GetCelebrityRecognitionResponse::celebrities)).setter(GetCelebrityRecognitionResponse.setter(Builder::celebrities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Celebrities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CelebrityRecognition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(GetCelebrityRecognitionResponse.getter(GetCelebrityRecognitionResponse::jobId)).setter(GetCelebrityRecognitionResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<Video> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Video").getter(GetCelebrityRecognitionResponse.getter(GetCelebrityRecognitionResponse::video)).setter(GetCelebrityRecognitionResponse.setter(Builder::video)).constructor(Video::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()}).build();
    private static final SdkField<String> JOB_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobTag").getter(GetCelebrityRecognitionResponse.getter(GetCelebrityRecognitionResponse::jobTag)).setter(GetCelebrityRecognitionResponse.setter(Builder::jobTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, NEXT_TOKEN_FIELD, CELEBRITIES_FIELD, JOB_ID_FIELD, VIDEO_FIELD, JOB_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCelebrityRecognitionResponse.memberNameToFieldInitializer();
    private final String jobStatus;
    private final String statusMessage;
    private final VideoMetadata videoMetadata;
    private final String nextToken;
    private final List<CelebrityRecognition> celebrities;
    private final String jobId;
    private final Video video;
    private final String jobTag;

    private GetCelebrityRecognitionResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.nextToken = builder.nextToken;
        this.celebrities = builder.celebrities;
        this.jobId = builder.jobId;
        this.video = builder.video;
        this.jobTag = builder.jobTag;
    }

    public final VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final VideoMetadata videoMetadata() {
        return this.videoMetadata;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCelebrities() {
        return this.celebrities != null && !(this.celebrities instanceof SdkAutoConstructList);
    }

    public final List<CelebrityRecognition> celebrities() {
        return this.celebrities;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final Video video() {
        return this.video;
    }

    public final String jobTag() {
        return this.jobTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCelebrities() ? this.celebrities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCelebrityRecognitionResponse)) {
            return false;
        }
        GetCelebrityRecognitionResponse other = (GetCelebrityRecognitionResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.videoMetadata(), other.videoMetadata()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasCelebrities() == other.hasCelebrities() && Objects.equals(this.celebrities(), other.celebrities()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.video(), other.video()) && Objects.equals(this.jobTag(), other.jobTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetCelebrityRecognitionResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("VideoMetadata", (Object)this.videoMetadata()).add("NextToken", (Object)this.nextToken()).add("Celebrities", this.hasCelebrities() ? this.celebrities() : null).add("JobId", (Object)this.jobId()).add("Video", (Object)this.video()).add("JobTag", (Object)this.jobTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "VideoMetadata": {
                return Optional.ofNullable(clazz.cast(this.videoMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Celebrities": {
                return Optional.ofNullable(clazz.cast(this.celebrities()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "JobTag": {
                return Optional.ofNullable(clazz.cast(this.jobTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("VideoMetadata", VIDEO_METADATA_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Celebrities", CELEBRITIES_FIELD);
        map.put("JobId", JOB_ID_FIELD);
        map.put("Video", VIDEO_FIELD);
        map.put("JobTag", JOB_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCelebrityRecognitionResponse, T> g) {
        return obj -> g.apply((GetCelebrityRecognitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String statusMessage;
        private VideoMetadata videoMetadata;
        private String nextToken;
        private List<CelebrityRecognition> celebrities = DefaultSdkAutoConstructList.getInstance();
        private String jobId;
        private Video video;
        private String jobTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCelebrityRecognitionResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.statusMessage(model.statusMessage);
            this.videoMetadata(model.videoMetadata);
            this.nextToken(model.nextToken);
            this.celebrities(model.celebrities);
            this.jobId(model.jobId);
            this.video(model.video);
            this.jobTag(model.jobTag);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return this.videoMetadata != null ? this.videoMetadata.toBuilder() : null;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CelebrityRecognition.Builder> getCelebrities() {
            List<CelebrityRecognition.Builder> result = CelebrityRecognitionsCopier.copyToBuilder(this.celebrities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCelebrities(Collection<CelebrityRecognition.BuilderImpl> celebrities) {
            this.celebrities = CelebrityRecognitionsCopier.copyFromBuilder(celebrities);
        }

        @Override
        public final Builder celebrities(Collection<CelebrityRecognition> celebrities) {
            this.celebrities = CelebrityRecognitionsCopier.copy(celebrities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrities(CelebrityRecognition ... celebrities) {
            this.celebrities(Arrays.asList(celebrities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrities(Consumer<CelebrityRecognition.Builder> ... celebrities) {
            this.celebrities(Stream.of(celebrities).map(c -> (CelebrityRecognition)((CelebrityRecognition.Builder)CelebrityRecognition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Video.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(Video.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(Video video) {
            this.video = video;
            return this;
        }

        public final String getJobTag() {
            return this.jobTag;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        @Override
        public GetCelebrityRecognitionResponse build() {
            return new GetCelebrityRecognitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCelebrityRecognitionResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(VideoJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder videoMetadata(VideoMetadata var1);

        default public Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return this.videoMetadata((VideoMetadata)((VideoMetadata.Builder)VideoMetadata.builder().applyMutation(videoMetadata)).build());
        }

        public Builder nextToken(String var1);

        public Builder celebrities(Collection<CelebrityRecognition> var1);

        public Builder celebrities(CelebrityRecognition ... var1);

        public Builder celebrities(Consumer<CelebrityRecognition.Builder> ... var1);

        public Builder jobId(String var1);

        public Builder video(Video var1);

        default public Builder video(Consumer<Video.Builder> video) {
            return this.video((Video)((Video.Builder)Video.builder().applyMutation(video)).build());
        }

        public Builder jobTag(String var1);
    }
}

