/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceIdListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFacesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, ListFacesRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionId").getter(ListFacesRequest.getter(ListFacesRequest::collectionId)).setter(ListFacesRequest.setter(Builder::collectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFacesRequest.getter(ListFacesRequest::nextToken)).setter(ListFacesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListFacesRequest.getter(ListFacesRequest::maxResults)).setter(ListFacesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(ListFacesRequest.getter(ListFacesRequest::userId)).setter(ListFacesRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<List<String>> FACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaceIds").getter(ListFacesRequest.getter(ListFacesRequest::faceIds)).setter(ListFacesRequest.setter(Builder::faceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, USER_ID_FIELD, FACE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFacesRequest.memberNameToFieldInitializer();
    private final String collectionId;
    private final String nextToken;
    private final Integer maxResults;
    private final String userId;
    private final List<String> faceIds;

    private ListFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.userId = builder.userId;
        this.faceIds = builder.faceIds;
    }

    public final String collectionId() {
        return this.collectionId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasFaceIds() {
        return this.faceIds != null && !(this.faceIds instanceof SdkAutoConstructList);
    }

    public final List<String> faceIds() {
        return this.faceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaceIds() ? this.faceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacesRequest)) {
            return false;
        }
        ListFacesRequest other = (ListFacesRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.userId(), other.userId()) && this.hasFaceIds() == other.hasFaceIds() && Objects.equals(this.faceIds(), other.faceIds());
    }

    public final String toString() {
        return ToString.builder((String)"ListFacesRequest").add("CollectionId", (Object)this.collectionId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("UserId", (Object)this.userId()).add("FaceIds", this.hasFaceIds() ? this.faceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "FaceIds": {
                return Optional.ofNullable(clazz.cast(this.faceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionId", COLLECTION_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("FaceIds", FACE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFacesRequest, T> g) {
        return obj -> g.apply((ListFacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;
        private String nextToken;
        private Integer maxResults;
        private String userId;
        private List<String> faceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacesRequest model) {
            super(model);
            this.collectionId(model.collectionId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.userId(model.userId);
            this.faceIds(model.faceIds);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getFaceIds() {
            if (this.faceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.faceIds;
        }

        public final void setFaceIds(Collection<String> faceIds) {
            this.faceIds = FaceIdListCopier.copy(faceIds);
        }

        @Override
        public final Builder faceIds(Collection<String> faceIds) {
            this.faceIds = FaceIdListCopier.copy(faceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceIds(String ... faceIds) {
            this.faceIds(Arrays.asList(faceIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFacesRequest build() {
            return new ListFacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFacesRequest> {
        public Builder collectionId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder userId(String var1);

        public Builder faceIds(Collection<String> var1);

        public Builder faceIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

