/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.SearchedFace;
import software.amazon.awssdk.services.rekognition.model.SearchedUser;
import software.amazon.awssdk.services.rekognition.model.UserMatch;
import software.amazon.awssdk.services.rekognition.model.UserMatchListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchUsersResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, SearchUsersResponse> {
    private static final SdkField<List<UserMatch>> USER_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserMatches").getter(SearchUsersResponse.getter(SearchUsersResponse::userMatches)).setter(SearchUsersResponse.setter(Builder::userMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaceModelVersion").getter(SearchUsersResponse.getter(SearchUsersResponse::faceModelVersion)).setter(SearchUsersResponse.setter(Builder::faceModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()}).build();
    private static final SdkField<SearchedFace> SEARCHED_FACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchedFace").getter(SearchUsersResponse.getter(SearchUsersResponse::searchedFace)).setter(SearchUsersResponse.setter(Builder::searchedFace)).constructor(SearchedFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedFace").build()}).build();
    private static final SdkField<SearchedUser> SEARCHED_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchedUser").getter(SearchUsersResponse.getter(SearchUsersResponse::searchedUser)).setter(SearchUsersResponse.setter(Builder::searchedUser)).constructor(SearchedUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedUser").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_MATCHES_FIELD, FACE_MODEL_VERSION_FIELD, SEARCHED_FACE_FIELD, SEARCHED_USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchUsersResponse.memberNameToFieldInitializer();
    private final List<UserMatch> userMatches;
    private final String faceModelVersion;
    private final SearchedFace searchedFace;
    private final SearchedUser searchedUser;

    private SearchUsersResponse(BuilderImpl builder) {
        super(builder);
        this.userMatches = builder.userMatches;
        this.faceModelVersion = builder.faceModelVersion;
        this.searchedFace = builder.searchedFace;
        this.searchedUser = builder.searchedUser;
    }

    public final boolean hasUserMatches() {
        return this.userMatches != null && !(this.userMatches instanceof SdkAutoConstructList);
    }

    public final List<UserMatch> userMatches() {
        return this.userMatches;
    }

    public final String faceModelVersion() {
        return this.faceModelVersion;
    }

    public final SearchedFace searchedFace() {
        return this.searchedFace;
    }

    public final SearchedUser searchedUser() {
        return this.searchedUser;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserMatches() ? this.userMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedFace());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedUser());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersResponse)) {
            return false;
        }
        SearchUsersResponse other = (SearchUsersResponse)((Object)obj);
        return this.hasUserMatches() == other.hasUserMatches() && Objects.equals(this.userMatches(), other.userMatches()) && Objects.equals(this.faceModelVersion(), other.faceModelVersion()) && Objects.equals(this.searchedFace(), other.searchedFace()) && Objects.equals(this.searchedUser(), other.searchedUser());
    }

    public final String toString() {
        return ToString.builder((String)"SearchUsersResponse").add("UserMatches", this.hasUserMatches() ? this.userMatches() : null).add("FaceModelVersion", (Object)this.faceModelVersion()).add("SearchedFace", (Object)this.searchedFace()).add("SearchedUser", (Object)this.searchedUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserMatches": {
                return Optional.ofNullable(clazz.cast(this.userMatches()));
            }
            case "FaceModelVersion": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersion()));
            }
            case "SearchedFace": {
                return Optional.ofNullable(clazz.cast(this.searchedFace()));
            }
            case "SearchedUser": {
                return Optional.ofNullable(clazz.cast(this.searchedUser()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserMatches", USER_MATCHES_FIELD);
        map.put("FaceModelVersion", FACE_MODEL_VERSION_FIELD);
        map.put("SearchedFace", SEARCHED_FACE_FIELD);
        map.put("SearchedUser", SEARCHED_USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchUsersResponse, T> g) {
        return obj -> g.apply((SearchUsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<UserMatch> userMatches = DefaultSdkAutoConstructList.getInstance();
        private String faceModelVersion;
        private SearchedFace searchedFace;
        private SearchedUser searchedUser;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUsersResponse model) {
            super(model);
            this.userMatches(model.userMatches);
            this.faceModelVersion(model.faceModelVersion);
            this.searchedFace(model.searchedFace);
            this.searchedUser(model.searchedUser);
        }

        public final List<UserMatch.Builder> getUserMatches() {
            List<UserMatch.Builder> result = UserMatchListCopier.copyToBuilder(this.userMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserMatches(Collection<UserMatch.BuilderImpl> userMatches) {
            this.userMatches = UserMatchListCopier.copyFromBuilder(userMatches);
        }

        @Override
        public final Builder userMatches(Collection<UserMatch> userMatches) {
            this.userMatches = UserMatchListCopier.copy(userMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMatches(UserMatch ... userMatches) {
            this.userMatches(Arrays.asList(userMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMatches(Consumer<UserMatch.Builder> ... userMatches) {
            this.userMatches(Stream.of(userMatches).map(c -> (UserMatch)((UserMatch.Builder)UserMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFaceModelVersion() {
            return this.faceModelVersion;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final SearchedFace.Builder getSearchedFace() {
            return this.searchedFace != null ? this.searchedFace.toBuilder() : null;
        }

        public final void setSearchedFace(SearchedFace.BuilderImpl searchedFace) {
            this.searchedFace = searchedFace != null ? searchedFace.build() : null;
        }

        @Override
        public final Builder searchedFace(SearchedFace searchedFace) {
            this.searchedFace = searchedFace;
            return this;
        }

        public final SearchedUser.Builder getSearchedUser() {
            return this.searchedUser != null ? this.searchedUser.toBuilder() : null;
        }

        public final void setSearchedUser(SearchedUser.BuilderImpl searchedUser) {
            this.searchedUser = searchedUser != null ? searchedUser.build() : null;
        }

        @Override
        public final Builder searchedUser(SearchedUser searchedUser) {
            this.searchedUser = searchedUser;
            return this;
        }

        @Override
        public SearchUsersResponse build() {
            return new SearchUsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchUsersResponse> {
        public Builder userMatches(Collection<UserMatch> var1);

        public Builder userMatches(UserMatch ... var1);

        public Builder userMatches(Consumer<UserMatch.Builder> ... var1);

        public Builder faceModelVersion(String var1);

        public Builder searchedFace(SearchedFace var1);

        default public Builder searchedFace(Consumer<SearchedFace.Builder> searchedFace) {
            return this.searchedFace((SearchedFace)((SearchedFace.Builder)SearchedFace.builder().applyMutation(searchedFace)).build());
        }

        public Builder searchedUser(SearchedUser var1);

        default public Builder searchedUser(Consumer<SearchedUser.Builder> searchedUser) {
            return this.searchedUser((SearchedUser)((SearchedUser.Builder)SearchedUser.builder().applyMutation(searchedUser)).build());
        }
    }
}

