/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetStore {
    ONLINE_STORE("OnlineStore"),
    OFFLINE_STORE("OfflineStore"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetStore> VALUE_MAP;
    private final String value;

    private TargetStore(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetStore fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetStore> knownValues() {
        EnumSet<TargetStore> knownValues = EnumSet.allOf(TargetStore.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetStore.class, TargetStore::toString);
    }
}

