/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanArnListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilter;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanFilterListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanIdListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanState;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanStateListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsplansRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSavingsPlansRequest
extends SavingsplansRequest
implements ToCopyableBuilder<Builder, DescribeSavingsPlansRequest> {
    private static final SdkField<List<String>> SAVINGS_PLAN_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansRequest.getter(DescribeSavingsPlansRequest::savingsPlanArns)).setter(DescribeSavingsPlansRequest.setter(Builder::savingsPlanArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SAVINGS_PLAN_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansRequest.getter(DescribeSavingsPlansRequest::savingsPlanIds)).setter(DescribeSavingsPlansRequest.setter(Builder::savingsPlanIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSavingsPlansRequest.getter(DescribeSavingsPlansRequest::nextToken)).setter(DescribeSavingsPlansRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeSavingsPlansRequest.getter(DescribeSavingsPlansRequest::maxResults)).setter(DescribeSavingsPlansRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansRequest.getter(DescribeSavingsPlansRequest::statesAsStrings)).setter(DescribeSavingsPlansRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("states").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SavingsPlanFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansRequest.getter(DescribeSavingsPlansRequest::filters)).setter(DescribeSavingsPlansRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlanFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_ARNS_FIELD, SAVINGS_PLAN_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATES_FIELD, FILTERS_FIELD));
    private final List<String> savingsPlanArns;
    private final List<String> savingsPlanIds;
    private final String nextToken;
    private final Integer maxResults;
    private final List<String> states;
    private final List<SavingsPlanFilter> filters;

    private DescribeSavingsPlansRequest(BuilderImpl builder) {
        super(builder);
        this.savingsPlanArns = builder.savingsPlanArns;
        this.savingsPlanIds = builder.savingsPlanIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.states = builder.states;
        this.filters = builder.filters;
    }

    public boolean hasSavingsPlanArns() {
        return this.savingsPlanArns != null && !(this.savingsPlanArns instanceof SdkAutoConstructList);
    }

    public List<String> savingsPlanArns() {
        return this.savingsPlanArns;
    }

    public boolean hasSavingsPlanIds() {
        return this.savingsPlanIds != null && !(this.savingsPlanIds instanceof SdkAutoConstructList);
    }

    public List<String> savingsPlanIds() {
        return this.savingsPlanIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public List<SavingsPlanState> states() {
        return SavingsPlanStateListCopier.copyStringToEnum(this.states);
    }

    public boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public List<String> statesAsStrings() {
        return this.states;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<SavingsPlanFilter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.statesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansRequest)) {
            return false;
        }
        DescribeSavingsPlansRequest other = (DescribeSavingsPlansRequest)((Object)obj);
        return Objects.equals(this.savingsPlanArns(), other.savingsPlanArns()) && Objects.equals(this.savingsPlanIds(), other.savingsPlanIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && Objects.equals(this.filters(), other.filters());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSavingsPlansRequest").add("SavingsPlanArns", this.savingsPlanArns()).add("SavingsPlanIds", this.savingsPlanIds()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("States", this.statesAsStrings()).add("Filters", this.filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "savingsPlanArns": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanArns()));
            }
            case "savingsPlanIds": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanIds()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "states": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansRequest, T> g) {
        return obj -> g.apply((DescribeSavingsPlansRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SavingsplansRequest.BuilderImpl
    implements Builder {
        private List<String> savingsPlanArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> savingsPlanIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private List<SavingsPlanFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansRequest model) {
            super(model);
            this.savingsPlanArns(model.savingsPlanArns);
            this.savingsPlanIds(model.savingsPlanIds);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.statesWithStrings(model.states);
            this.filters(model.filters);
        }

        public final Collection<String> getSavingsPlanArns() {
            return this.savingsPlanArns;
        }

        @Override
        public final Builder savingsPlanArns(Collection<String> savingsPlanArns) {
            this.savingsPlanArns = SavingsPlanArnListCopier.copy(savingsPlanArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanArns(String ... savingsPlanArns) {
            this.savingsPlanArns(Arrays.asList(savingsPlanArns));
            return this;
        }

        public final void setSavingsPlanArns(Collection<String> savingsPlanArns) {
            this.savingsPlanArns = SavingsPlanArnListCopier.copy(savingsPlanArns);
        }

        public final Collection<String> getSavingsPlanIds() {
            return this.savingsPlanIds;
        }

        @Override
        public final Builder savingsPlanIds(Collection<String> savingsPlanIds) {
            this.savingsPlanIds = SavingsPlanIdListCopier.copy(savingsPlanIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanIds(String ... savingsPlanIds) {
            this.savingsPlanIds(Arrays.asList(savingsPlanIds));
            return this;
        }

        public final void setSavingsPlanIds(Collection<String> savingsPlanIds) {
            this.savingsPlanIds = SavingsPlanIdListCopier.copy(savingsPlanIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<String> getStates() {
            return this.states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = SavingsPlanStateListCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<SavingsPlanState> states) {
            this.states = SavingsPlanStateListCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(SavingsPlanState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final void setStates(Collection<String> states) {
            this.states = SavingsPlanStateListCopier.copy(states);
        }

        public final Collection<SavingsPlanFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(SavingsPlanFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<SavingsPlanFilter> filters) {
            this.filters = SavingsPlanFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SavingsPlanFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SavingsPlanFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (SavingsPlanFilter)((SavingsPlanFilter.Builder)SavingsPlanFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<SavingsPlanFilter.BuilderImpl> filters) {
            this.filters = SavingsPlanFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSavingsPlansRequest build() {
            return new DescribeSavingsPlansRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SavingsplansRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSavingsPlansRequest> {
        public Builder savingsPlanArns(Collection<String> var1);

        public Builder savingsPlanArns(String ... var1);

        public Builder savingsPlanIds(Collection<String> var1);

        public Builder savingsPlanIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<SavingsPlanState> var1);

        public Builder states(SavingsPlanState ... var1);

        public Builder filters(Collection<SavingsPlanFilter> var1);

        public Builder filters(SavingsPlanFilter ... var1);

        public Builder filters(Consumer<SavingsPlanFilter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

