/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For each message in the batch, the response contains a <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code>
 * tag if the message succeeds or a <code> <a>BatchResultErrorEntry</a> </code> tag if the message fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeMessageVisibilityBatchResponse extends SqsResponse implements
        ToCopyableBuilder<ChangeMessageVisibilityBatchResponse.Builder, ChangeMessageVisibilityBatchResponse> {
    private static final SdkField<List<ChangeMessageVisibilityBatchResultEntry>> SUCCESSFUL_FIELD = SdkField
            .<List<ChangeMessageVisibilityBatchResultEntry>> builder(MarshallingType.LIST)
            .memberName("Successful")
            .getter(getter(ChangeMessageVisibilityBatchResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeMessageVisibilityBatchResultEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeMessageVisibilityBatchResultEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).isFlattened(true).build()).build();

    private static final SdkField<List<BatchResultErrorEntry>> FAILED_FIELD = SdkField
            .<List<BatchResultErrorEntry>> builder(MarshallingType.LIST)
            .memberName("Failed")
            .getter(getter(ChangeMessageVisibilityBatchResponse::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchResultErrorEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchResultErrorEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).isFlattened(true).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUCCESSFUL_FIELD, FAILED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ChangeMessageVisibilityBatchResultEntry> successful;

    private final List<BatchResultErrorEntry> failed;

    private ChangeMessageVisibilityBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successful property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessful} method.
     * </p>
     * 
     * @return A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
     */
    public final List<ChangeMessageVisibilityBatchResultEntry> successful() {
        return successful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failed property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailed() {
        return failed != null && !(failed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code> <a>BatchResultErrorEntry</a> </code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailed} method.
     * </p>
     * 
     * @return A list of <code> <a>BatchResultErrorEntry</a> </code> items.
     */
    public final List<BatchResultErrorEntry> failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailed() ? failed() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityBatchResponse)) {
            return false;
        }
        ChangeMessageVisibilityBatchResponse other = (ChangeMessageVisibilityBatchResponse) obj;
        return hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful())
                && hasFailed() == other.hasFailed() && Objects.equals(failed(), other.failed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeMessageVisibilityBatchResponse").add("Successful", hasSuccessful() ? successful() : null)
                .add("Failed", hasFailed() ? failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Successful", SUCCESSFUL_FIELD);
        map.put("Failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeMessageVisibilityBatchResponse, T> g) {
        return obj -> g.apply((ChangeMessageVisibilityBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SqsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ChangeMessageVisibilityBatchResponse> {
        /**
         * <p>
         * A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
         * </p>
         * 
         * @param successful
         *        A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<ChangeMessageVisibilityBatchResultEntry> successful);

        /**
         * <p>
         * A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
         * </p>
         * 
         * @param successful
         *        A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(ChangeMessageVisibilityBatchResultEntry... successful);

        /**
         * <p>
         * A list of <code> <a>ChangeMessageVisibilityBatchResultEntry</a> </code> items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResultEntry.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResultEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResultEntry.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #successful(List<ChangeMessageVisibilityBatchResultEntry>)}.
         * 
         * @param successful
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResultEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(java.util.Collection<ChangeMessageVisibilityBatchResultEntry>)
         */
        Builder successful(Consumer<ChangeMessageVisibilityBatchResultEntry.Builder>... successful);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * </p>
         * 
         * @param failed
         *        A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<BatchResultErrorEntry> failed);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * </p>
         * 
         * @param failed
         *        A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(BatchResultErrorEntry... failed);

        /**
         * <p>
         * A list of <code> <a>BatchResultErrorEntry</a> </code> items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry.Builder#build()} is called immediately
         * and its result is passed to {@link #failed(List<BatchResultErrorEntry>)}.
         * 
         * @param failed
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(java.util.Collection<BatchResultErrorEntry>)
         */
        Builder failed(Consumer<BatchResultErrorEntry.Builder>... failed);
    }

    static final class BuilderImpl extends SqsResponse.BuilderImpl implements Builder {
        private List<ChangeMessageVisibilityBatchResultEntry> successful = DefaultSdkAutoConstructList.getInstance();

        private List<BatchResultErrorEntry> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityBatchResponse model) {
            super(model);
            successful(model.successful);
            failed(model.failed);
        }

        public final List<ChangeMessageVisibilityBatchResultEntry.Builder> getSuccessful() {
            List<ChangeMessageVisibilityBatchResultEntry.Builder> result = ChangeMessageVisibilityBatchResultEntryListCopier
                    .copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<ChangeMessageVisibilityBatchResultEntry.BuilderImpl> successful) {
            this.successful = ChangeMessageVisibilityBatchResultEntryListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<ChangeMessageVisibilityBatchResultEntry> successful) {
            this.successful = ChangeMessageVisibilityBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(ChangeMessageVisibilityBatchResultEntry... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<ChangeMessageVisibilityBatchResultEntry.Builder>... successful) {
            successful(Stream.of(successful).map(c -> ChangeMessageVisibilityBatchResultEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchResultErrorEntry.Builder> getFailed() {
            List<BatchResultErrorEntry.Builder> result = BatchResultErrorEntryListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchResultErrorEntry.BuilderImpl> failed) {
            this.failed = BatchResultErrorEntryListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchResultErrorEntry.Builder>... failed) {
            failed(Stream.of(failed).map(c -> BatchResultErrorEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ChangeMessageVisibilityBatchResponse build() {
            return new ChangeMessageVisibilityBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
