/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse;
import software.amazon.awssdk.services.ssm.model.Patch;

public class DescribeAvailablePatchesIterable
implements SdkIterable<DescribeAvailablePatchesResponse> {
    private final SsmClient client;
    private final DescribeAvailablePatchesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAvailablePatchesIterable(SsmClient client, DescribeAvailablePatchesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAvailablePatchesResponseFetcher();
    }

    public Iterator<DescribeAvailablePatchesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Patch> patches() {
        Function<DescribeAvailablePatchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.patches() != null) {
                return response.patches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAvailablePatchesResponseFetcher
    implements SyncPageFetcher<DescribeAvailablePatchesResponse> {
        private DescribeAvailablePatchesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAvailablePatchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAvailablePatchesResponse nextPage(DescribeAvailablePatchesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAvailablePatchesIterable.this.client.describeAvailablePatches(DescribeAvailablePatchesIterable.this.firstRequest);
            }
            return DescribeAvailablePatchesIterable.this.client.describeAvailablePatches((DescribeAvailablePatchesRequest)((Object)DescribeAvailablePatchesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

