/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget;

public class DescribeMaintenanceWindowTargetsIterable
implements SdkIterable<DescribeMaintenanceWindowTargetsResponse> {
    private final SsmClient client;
    private final DescribeMaintenanceWindowTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMaintenanceWindowTargetsIterable(SsmClient client, DescribeMaintenanceWindowTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMaintenanceWindowTargetsResponseFetcher();
    }

    public Iterator<DescribeMaintenanceWindowTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MaintenanceWindowTarget> targets() {
        Function<DescribeMaintenanceWindowTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targets() != null) {
                return response.targets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMaintenanceWindowTargetsResponseFetcher
    implements SyncPageFetcher<DescribeMaintenanceWindowTargetsResponse> {
        private DescribeMaintenanceWindowTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMaintenanceWindowTargetsResponse nextPage(DescribeMaintenanceWindowTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowTargetsIterable.this.client.describeMaintenanceWindowTargets(DescribeMaintenanceWindowTargetsIterable.this.firstRequest);
            }
            return DescribeMaintenanceWindowTargetsIterable.this.client.describeMaintenanceWindowTargets((DescribeMaintenanceWindowTargetsRequest)((Object)DescribeMaintenanceWindowTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

