/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DecisionType {
    SCHEDULE_ACTIVITY_TASK("ScheduleActivityTask"),
    REQUEST_CANCEL_ACTIVITY_TASK("RequestCancelActivityTask"),
    COMPLETE_WORKFLOW_EXECUTION("CompleteWorkflowExecution"),
    FAIL_WORKFLOW_EXECUTION("FailWorkflowExecution"),
    CANCEL_WORKFLOW_EXECUTION("CancelWorkflowExecution"),
    CONTINUE_AS_NEW_WORKFLOW_EXECUTION("ContinueAsNewWorkflowExecution"),
    RECORD_MARKER("RecordMarker"),
    START_TIMER("StartTimer"),
    CANCEL_TIMER("CancelTimer"),
    SIGNAL_EXTERNAL_WORKFLOW_EXECUTION("SignalExternalWorkflowExecution"),
    REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION("RequestCancelExternalWorkflowExecution"),
    START_CHILD_WORKFLOW_EXECUTION("StartChildWorkflowExecution"),
    SCHEDULE_LAMBDA_FUNCTION("ScheduleLambdaFunction"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DecisionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DecisionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DecisionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DecisionType> knownValues() {
        return Stream.of(DecisionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

