/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.WorkflowExecution;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionCancelRequestedCause;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowExecutionCancelRequestedEventAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowExecutionCancelRequestedEventAttributes> {
    private static final SdkField<WorkflowExecution> EXTERNAL_WORKFLOW_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WorkflowExecutionCancelRequestedEventAttributes.getter(WorkflowExecutionCancelRequestedEventAttributes::externalWorkflowExecution)).setter(WorkflowExecutionCancelRequestedEventAttributes.setter(Builder::externalWorkflowExecution)).constructor(WorkflowExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalWorkflowExecution").build()}).build();
    private static final SdkField<Long> EXTERNAL_INITIATED_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(WorkflowExecutionCancelRequestedEventAttributes.getter(WorkflowExecutionCancelRequestedEventAttributes::externalInitiatedEventId)).setter(WorkflowExecutionCancelRequestedEventAttributes.setter(Builder::externalInitiatedEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalInitiatedEventId").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkflowExecutionCancelRequestedEventAttributes.getter(WorkflowExecutionCancelRequestedEventAttributes::causeAsString)).setter(WorkflowExecutionCancelRequestedEventAttributes.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_WORKFLOW_EXECUTION_FIELD, EXTERNAL_INITIATED_EVENT_ID_FIELD, CAUSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final WorkflowExecution externalWorkflowExecution;
    private final Long externalInitiatedEventId;
    private final String cause;

    private WorkflowExecutionCancelRequestedEventAttributes(BuilderImpl builder) {
        this.externalWorkflowExecution = builder.externalWorkflowExecution;
        this.externalInitiatedEventId = builder.externalInitiatedEventId;
        this.cause = builder.cause;
    }

    public WorkflowExecution externalWorkflowExecution() {
        return this.externalWorkflowExecution;
    }

    public Long externalInitiatedEventId() {
        return this.externalInitiatedEventId;
    }

    public WorkflowExecutionCancelRequestedCause cause() {
        return WorkflowExecutionCancelRequestedCause.fromValue(this.cause);
    }

    public String causeAsString() {
        return this.cause;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.externalWorkflowExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalInitiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.causeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionCancelRequestedEventAttributes)) {
            return false;
        }
        WorkflowExecutionCancelRequestedEventAttributes other = (WorkflowExecutionCancelRequestedEventAttributes)obj;
        return Objects.equals(this.externalWorkflowExecution(), other.externalWorkflowExecution()) && Objects.equals(this.externalInitiatedEventId(), other.externalInitiatedEventId()) && Objects.equals(this.causeAsString(), other.causeAsString());
    }

    public String toString() {
        return ToString.builder((String)"WorkflowExecutionCancelRequestedEventAttributes").add("ExternalWorkflowExecution", (Object)this.externalWorkflowExecution()).add("ExternalInitiatedEventId", (Object)this.externalInitiatedEventId()).add("Cause", (Object)this.causeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "externalWorkflowExecution": {
                return Optional.ofNullable(clazz.cast(this.externalWorkflowExecution()));
            }
            case "externalInitiatedEventId": {
                return Optional.ofNullable(clazz.cast(this.externalInitiatedEventId()));
            }
            case "cause": {
                return Optional.ofNullable(clazz.cast(this.causeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionCancelRequestedEventAttributes, T> g) {
        return obj -> g.apply((WorkflowExecutionCancelRequestedEventAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WorkflowExecution externalWorkflowExecution;
        private Long externalInitiatedEventId;
        private String cause;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionCancelRequestedEventAttributes model) {
            this.externalWorkflowExecution(model.externalWorkflowExecution);
            this.externalInitiatedEventId(model.externalInitiatedEventId);
            this.cause(model.cause);
        }

        public final WorkflowExecution.Builder getExternalWorkflowExecution() {
            return this.externalWorkflowExecution != null ? this.externalWorkflowExecution.toBuilder() : null;
        }

        @Override
        public final Builder externalWorkflowExecution(WorkflowExecution externalWorkflowExecution) {
            this.externalWorkflowExecution = externalWorkflowExecution;
            return this;
        }

        public final void setExternalWorkflowExecution(WorkflowExecution.BuilderImpl externalWorkflowExecution) {
            this.externalWorkflowExecution = externalWorkflowExecution != null ? externalWorkflowExecution.build() : null;
        }

        public final Long getExternalInitiatedEventId() {
            return this.externalInitiatedEventId;
        }

        @Override
        public final Builder externalInitiatedEventId(Long externalInitiatedEventId) {
            this.externalInitiatedEventId = externalInitiatedEventId;
            return this;
        }

        public final void setExternalInitiatedEventId(Long externalInitiatedEventId) {
            this.externalInitiatedEventId = externalInitiatedEventId;
        }

        public final String getCause() {
            return this.cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public final Builder cause(WorkflowExecutionCancelRequestedCause cause) {
            this.cause(cause.toString());
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        public WorkflowExecutionCancelRequestedEventAttributes build() {
            return new WorkflowExecutionCancelRequestedEventAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowExecutionCancelRequestedEventAttributes> {
        public Builder externalWorkflowExecution(WorkflowExecution var1);

        default public Builder externalWorkflowExecution(Consumer<WorkflowExecution.Builder> externalWorkflowExecution) {
            return this.externalWorkflowExecution((WorkflowExecution)((WorkflowExecution.Builder)WorkflowExecution.builder().applyMutation(externalWorkflowExecution)).build());
        }

        public Builder externalInitiatedEventId(Long var1);

        public Builder cause(String var1);

        public Builder cause(WorkflowExecutionCancelRequestedCause var1);
    }
}

