/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowExecutionTerminatedEventAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowExecutionTerminatedEventAttributes> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkflowExecutionTerminatedEventAttributes.getter(WorkflowExecutionTerminatedEventAttributes::reason)).setter(WorkflowExecutionTerminatedEventAttributes.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkflowExecutionTerminatedEventAttributes.getter(WorkflowExecutionTerminatedEventAttributes::details)).setter(WorkflowExecutionTerminatedEventAttributes.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()}).build();
    private static final SdkField<String> CHILD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkflowExecutionTerminatedEventAttributes.getter(WorkflowExecutionTerminatedEventAttributes::childPolicyAsString)).setter(WorkflowExecutionTerminatedEventAttributes.setter(Builder::childPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childPolicy").build()}).build();
    private static final SdkField<String> CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WorkflowExecutionTerminatedEventAttributes.getter(WorkflowExecutionTerminatedEventAttributes::causeAsString)).setter(WorkflowExecutionTerminatedEventAttributes.setter(Builder::cause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, DETAILS_FIELD, CHILD_POLICY_FIELD, CAUSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final String details;
    private final String childPolicy;
    private final String cause;

    private WorkflowExecutionTerminatedEventAttributes(BuilderImpl builder) {
        this.reason = builder.reason;
        this.details = builder.details;
        this.childPolicy = builder.childPolicy;
        this.cause = builder.cause;
    }

    public String reason() {
        return this.reason;
    }

    public String details() {
        return this.details;
    }

    public ChildPolicy childPolicy() {
        return ChildPolicy.fromValue(this.childPolicy);
    }

    public String childPolicyAsString() {
        return this.childPolicy;
    }

    public WorkflowExecutionTerminatedCause cause() {
        return WorkflowExecutionTerminatedCause.fromValue(this.cause);
    }

    public String causeAsString() {
        return this.cause;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.childPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.causeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionTerminatedEventAttributes)) {
            return false;
        }
        WorkflowExecutionTerminatedEventAttributes other = (WorkflowExecutionTerminatedEventAttributes)obj;
        return Objects.equals(this.reason(), other.reason()) && Objects.equals(this.details(), other.details()) && Objects.equals(this.childPolicyAsString(), other.childPolicyAsString()) && Objects.equals(this.causeAsString(), other.causeAsString());
    }

    public String toString() {
        return ToString.builder((String)"WorkflowExecutionTerminatedEventAttributes").add("Reason", (Object)this.reason()).add("Details", (Object)this.details()).add("ChildPolicy", (Object)this.childPolicyAsString()).add("Cause", (Object)this.causeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "childPolicy": {
                return Optional.ofNullable(clazz.cast(this.childPolicyAsString()));
            }
            case "cause": {
                return Optional.ofNullable(clazz.cast(this.causeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionTerminatedEventAttributes, T> g) {
        return obj -> g.apply((WorkflowExecutionTerminatedEventAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reason;
        private String details;
        private String childPolicy;
        private String cause;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionTerminatedEventAttributes model) {
            this.reason(model.reason);
            this.details(model.details);
            this.childPolicy(model.childPolicy);
            this.cause(model.cause);
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        public final String getChildPolicy() {
            return this.childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final String getCause() {
            return this.cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public final Builder cause(WorkflowExecutionTerminatedCause cause) {
            this.cause(cause.toString());
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        public WorkflowExecutionTerminatedEventAttributes build() {
            return new WorkflowExecutionTerminatedEventAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowExecutionTerminatedEventAttributes> {
        public Builder reason(String var1);

        public Builder details(String var1);

        public Builder childPolicy(String var1);

        public Builder childPolicy(ChildPolicy var1);

        public Builder cause(String var1);

        public Builder cause(WorkflowExecutionTerminatedCause var1);
    }
}

