/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.ActivityTypeInfo;
import software.amazon.awssdk.services.swf.model.ListActivityTypesRequest;
import software.amazon.awssdk.services.swf.model.ListActivityTypesResponse;

public class ListActivityTypesIterable
implements SdkIterable<ListActivityTypesResponse> {
    private final SwfClient client;
    private final ListActivityTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListActivityTypesIterable(SwfClient client, ListActivityTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListActivityTypesResponseFetcher();
    }

    public Iterator<ListActivityTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActivityTypeInfo> typeInfos() {
        Function<ListActivityTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.typeInfos() != null) {
                return response.typeInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListActivityTypesIterable resume(ListActivityTypesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListActivityTypesIterable(this.client, (ListActivityTypesRequest)((Object)this.firstRequest.toBuilder().nextPageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListActivityTypesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListActivityTypesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListActivityTypesResponseFetcher
    implements SyncPageFetcher<ListActivityTypesResponse> {
        private ListActivityTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListActivityTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListActivityTypesResponse nextPage(ListActivityTypesResponse previousPage) {
            if (previousPage == null) {
                return ListActivityTypesIterable.this.client.listActivityTypes(ListActivityTypesIterable.this.firstRequest);
            }
            return ListActivityTypesIterable.this.client.listActivityTypes((ListActivityTypesRequest)((Object)ListActivityTypesIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

