/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsClient;
import software.amazon.awssdk.services.synthetics.internal.UserAgentUtils;
import software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunRequest;
import software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunResponse;

public class DescribeCanariesLastRunIterable
implements SdkIterable<DescribeCanariesLastRunResponse> {
    private final SyntheticsClient client;
    private final DescribeCanariesLastRunRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCanariesLastRunIterable(SyntheticsClient client, DescribeCanariesLastRunRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCanariesLastRunResponseFetcher();
    }

    public Iterator<DescribeCanariesLastRunResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeCanariesLastRunResponseFetcher
    implements SyncPageFetcher<DescribeCanariesLastRunResponse> {
        private DescribeCanariesLastRunResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCanariesLastRunResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCanariesLastRunResponse nextPage(DescribeCanariesLastRunResponse previousPage) {
            if (previousPage == null) {
                return DescribeCanariesLastRunIterable.this.client.describeCanariesLastRun(DescribeCanariesLastRunIterable.this.firstRequest);
            }
            return DescribeCanariesLastRunIterable.this.client.describeCanariesLastRun((DescribeCanariesLastRunRequest)((Object)DescribeCanariesLastRunIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

