/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsAsyncClient;
import software.amazon.awssdk.services.synthetics.internal.UserAgentUtils;
import software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsRequest;
import software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsResponse;

public class DescribeRuntimeVersionsPublisher
implements SdkPublisher<DescribeRuntimeVersionsResponse> {
    private final SyntheticsAsyncClient client;
    private final DescribeRuntimeVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRuntimeVersionsPublisher(SyntheticsAsyncClient client, DescribeRuntimeVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRuntimeVersionsPublisher(SyntheticsAsyncClient client, DescribeRuntimeVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRuntimeVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRuntimeVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeRuntimeVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeRuntimeVersionsResponse> {
        private DescribeRuntimeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRuntimeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRuntimeVersionsResponse> nextPage(DescribeRuntimeVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRuntimeVersionsPublisher.this.client.describeRuntimeVersions(DescribeRuntimeVersionsPublisher.this.firstRequest);
            }
            return DescribeRuntimeVersionsPublisher.this.client.describeRuntimeVersions((DescribeRuntimeVersionsRequest)((Object)DescribeRuntimeVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

