/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.taxsettings.TaxSettingsClient;
import software.amazon.awssdk.services.taxsettings.internal.UserAgentUtils;
import software.amazon.awssdk.services.taxsettings.model.AccountDetails;
import software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsResponse;

public class ListTaxRegistrationsIterable
implements SdkIterable<ListTaxRegistrationsResponse> {
    private final TaxSettingsClient client;
    private final ListTaxRegistrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTaxRegistrationsIterable(TaxSettingsClient client, ListTaxRegistrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTaxRegistrationsResponseFetcher();
    }

    public Iterator<ListTaxRegistrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountDetails> accountDetails() {
        Function<ListTaxRegistrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountDetails() != null) {
                return response.accountDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTaxRegistrationsResponseFetcher
    implements SyncPageFetcher<ListTaxRegistrationsResponse> {
        private ListTaxRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTaxRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTaxRegistrationsResponse nextPage(ListTaxRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return ListTaxRegistrationsIterable.this.client.listTaxRegistrations(ListTaxRegistrationsIterable.this.firstRequest);
            }
            return ListTaxRegistrationsIterable.this.client.listTaxRegistrations((ListTaxRegistrationsRequest)((Object)ListTaxRegistrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

