/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.As2ConnectorConfig;
import software.amazon.awssdk.services.transfer.model.SftpConnectorConfig;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectorRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, CreateConnectorRequest> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(CreateConnectorRequest.getter(CreateConnectorRequest::url)).setter(CreateConnectorRequest.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<As2ConnectorConfig> AS2_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("As2Config").getter(CreateConnectorRequest.getter(CreateConnectorRequest::as2Config)).setter(CreateConnectorRequest.setter(Builder::as2Config)).constructor(As2ConnectorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2Config").build()}).build();
    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessRole").getter(CreateConnectorRequest.getter(CreateConnectorRequest::accessRole)).setter(CreateConnectorRequest.setter(Builder::accessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRole").build()}).build();
    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingRole").getter(CreateConnectorRequest.getter(CreateConnectorRequest::loggingRole)).setter(CreateConnectorRequest.setter(Builder::loggingRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateConnectorRequest.getter(CreateConnectorRequest::tags)).setter(CreateConnectorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SftpConnectorConfig> SFTP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SftpConfig").getter(CreateConnectorRequest.getter(CreateConnectorRequest::sftpConfig)).setter(CreateConnectorRequest.setter(Builder::sftpConfig)).constructor(SftpConnectorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SftpConfig").build()}).build();
    private static final SdkField<String> SECURITY_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityPolicyName").getter(CreateConnectorRequest.getter(CreateConnectorRequest::securityPolicyName)).setter(CreateConnectorRequest.setter(Builder::securityPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, AS2_CONFIG_FIELD, ACCESS_ROLE_FIELD, LOGGING_ROLE_FIELD, TAGS_FIELD, SFTP_CONFIG_FIELD, SECURITY_POLICY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectorRequest.memberNameToFieldInitializer();
    private final String url;
    private final As2ConnectorConfig as2Config;
    private final String accessRole;
    private final String loggingRole;
    private final List<Tag> tags;
    private final SftpConnectorConfig sftpConfig;
    private final String securityPolicyName;

    private CreateConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.as2Config = builder.as2Config;
        this.accessRole = builder.accessRole;
        this.loggingRole = builder.loggingRole;
        this.tags = builder.tags;
        this.sftpConfig = builder.sftpConfig;
        this.securityPolicyName = builder.securityPolicyName;
    }

    public final String url() {
        return this.url;
    }

    public final As2ConnectorConfig as2Config() {
        return this.as2Config;
    }

    public final String accessRole() {
        return this.accessRole;
    }

    public final String loggingRole() {
        return this.loggingRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final SftpConnectorConfig sftpConfig() {
        return this.sftpConfig;
    }

    public final String securityPolicyName() {
        return this.securityPolicyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.as2Config());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sftpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorRequest)) {
            return false;
        }
        CreateConnectorRequest other = (CreateConnectorRequest)((Object)obj);
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.as2Config(), other.as2Config()) && Objects.equals(this.accessRole(), other.accessRole()) && Objects.equals(this.loggingRole(), other.loggingRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sftpConfig(), other.sftpConfig()) && Objects.equals(this.securityPolicyName(), other.securityPolicyName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectorRequest").add("Url", (Object)this.url()).add("As2Config", (Object)this.as2Config()).add("AccessRole", (Object)this.accessRole()).add("LoggingRole", (Object)this.loggingRole()).add("Tags", this.hasTags() ? this.tags() : null).add("SftpConfig", (Object)this.sftpConfig()).add("SecurityPolicyName", (Object)this.securityPolicyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "As2Config": {
                return Optional.ofNullable(clazz.cast(this.as2Config()));
            }
            case "AccessRole": {
                return Optional.ofNullable(clazz.cast(this.accessRole()));
            }
            case "LoggingRole": {
                return Optional.ofNullable(clazz.cast(this.loggingRole()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SftpConfig": {
                return Optional.ofNullable(clazz.cast(this.sftpConfig()));
            }
            case "SecurityPolicyName": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Url", URL_FIELD);
        map.put("As2Config", AS2_CONFIG_FIELD);
        map.put("AccessRole", ACCESS_ROLE_FIELD);
        map.put("LoggingRole", LOGGING_ROLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SftpConfig", SFTP_CONFIG_FIELD);
        map.put("SecurityPolicyName", SECURITY_POLICY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorRequest, T> g) {
        return obj -> g.apply((CreateConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String url;
        private As2ConnectorConfig as2Config;
        private String accessRole;
        private String loggingRole;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private SftpConnectorConfig sftpConfig;
        private String securityPolicyName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorRequest model) {
            super(model);
            this.url(model.url);
            this.as2Config(model.as2Config);
            this.accessRole(model.accessRole);
            this.loggingRole(model.loggingRole);
            this.tags(model.tags);
            this.sftpConfig(model.sftpConfig);
            this.securityPolicyName(model.securityPolicyName);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final As2ConnectorConfig.Builder getAs2Config() {
            return this.as2Config != null ? this.as2Config.toBuilder() : null;
        }

        public final void setAs2Config(As2ConnectorConfig.BuilderImpl as2Config) {
            this.as2Config = as2Config != null ? as2Config.build() : null;
        }

        @Override
        public final Builder as2Config(As2ConnectorConfig as2Config) {
            this.as2Config = as2Config;
            return this;
        }

        public final String getAccessRole() {
            return this.accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        public final String getLoggingRole() {
            return this.loggingRole;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SftpConnectorConfig.Builder getSftpConfig() {
            return this.sftpConfig != null ? this.sftpConfig.toBuilder() : null;
        }

        public final void setSftpConfig(SftpConnectorConfig.BuilderImpl sftpConfig) {
            this.sftpConfig = sftpConfig != null ? sftpConfig.build() : null;
        }

        @Override
        public final Builder sftpConfig(SftpConnectorConfig sftpConfig) {
            this.sftpConfig = sftpConfig;
            return this;
        }

        public final String getSecurityPolicyName() {
            return this.securityPolicyName;
        }

        public final void setSecurityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
        }

        @Override
        public final Builder securityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorRequest build() {
            return new CreateConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectorRequest> {
        public Builder url(String var1);

        public Builder as2Config(As2ConnectorConfig var1);

        default public Builder as2Config(Consumer<As2ConnectorConfig.Builder> as2Config) {
            return this.as2Config((As2ConnectorConfig)((As2ConnectorConfig.Builder)As2ConnectorConfig.builder().applyMutation(as2Config)).build());
        }

        public Builder accessRole(String var1);

        public Builder loggingRole(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder sftpConfig(SftpConnectorConfig var1);

        default public Builder sftpConfig(Consumer<SftpConnectorConfig.Builder> sftpConfig) {
            return this.sftpConfig((SftpConnectorConfig)((SftpConnectorConfig.Builder)SftpConnectorConfig.builder().applyMutation(sftpConfig)).build());
        }

        public Builder securityPolicyName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

