/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.CertificateIdsCopier;
import software.amazon.awssdk.services.transfer.model.ProfileType;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProfileRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, CreateProfileRequest> {
    private static final SdkField<String> AS2_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("As2Id").getter(CreateProfileRequest.getter(CreateProfileRequest::as2Id)).setter(CreateProfileRequest.setter(Builder::as2Id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2Id").build()}).build();
    private static final SdkField<String> PROFILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileType").getter(CreateProfileRequest.getter(CreateProfileRequest::profileTypeAsString)).setter(CreateProfileRequest.setter(Builder::profileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileType").build()}).build();
    private static final SdkField<List<String>> CERTIFICATE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CertificateIds").getter(CreateProfileRequest.getter(CreateProfileRequest::certificateIds)).setter(CreateProfileRequest.setter(Builder::certificateIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateProfileRequest.getter(CreateProfileRequest::tags)).setter(CreateProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AS2_ID_FIELD, PROFILE_TYPE_FIELD, CERTIFICATE_IDS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProfileRequest.memberNameToFieldInitializer();
    private final String as2Id;
    private final String profileType;
    private final List<String> certificateIds;
    private final List<Tag> tags;

    private CreateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.as2Id = builder.as2Id;
        this.profileType = builder.profileType;
        this.certificateIds = builder.certificateIds;
        this.tags = builder.tags;
    }

    public final String as2Id() {
        return this.as2Id;
    }

    public final ProfileType profileType() {
        return ProfileType.fromValue(this.profileType);
    }

    public final String profileTypeAsString() {
        return this.profileType;
    }

    public final boolean hasCertificateIds() {
        return this.certificateIds != null && !(this.certificateIds instanceof SdkAutoConstructList);
    }

    public final List<String> certificateIds() {
        return this.certificateIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.as2Id());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateIds() ? this.certificateIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileRequest)) {
            return false;
        }
        CreateProfileRequest other = (CreateProfileRequest)((Object)obj);
        return Objects.equals(this.as2Id(), other.as2Id()) && Objects.equals(this.profileTypeAsString(), other.profileTypeAsString()) && this.hasCertificateIds() == other.hasCertificateIds() && Objects.equals(this.certificateIds(), other.certificateIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProfileRequest").add("As2Id", (Object)this.as2Id()).add("ProfileType", (Object)this.profileTypeAsString()).add("CertificateIds", this.hasCertificateIds() ? this.certificateIds() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "As2Id": {
                return Optional.ofNullable(clazz.cast(this.as2Id()));
            }
            case "ProfileType": {
                return Optional.ofNullable(clazz.cast(this.profileTypeAsString()));
            }
            case "CertificateIds": {
                return Optional.ofNullable(clazz.cast(this.certificateIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("As2Id", AS2_ID_FIELD);
        map.put("ProfileType", PROFILE_TYPE_FIELD);
        map.put("CertificateIds", CERTIFICATE_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProfileRequest, T> g) {
        return obj -> g.apply((CreateProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String as2Id;
        private String profileType;
        private List<String> certificateIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileRequest model) {
            super(model);
            this.as2Id(model.as2Id);
            this.profileType(model.profileType);
            this.certificateIds(model.certificateIds);
            this.tags(model.tags);
        }

        public final String getAs2Id() {
            return this.as2Id;
        }

        public final void setAs2Id(String as2Id) {
            this.as2Id = as2Id;
        }

        @Override
        public final Builder as2Id(String as2Id) {
            this.as2Id = as2Id;
            return this;
        }

        public final String getProfileType() {
            return this.profileType;
        }

        public final void setProfileType(String profileType) {
            this.profileType = profileType;
        }

        @Override
        public final Builder profileType(String profileType) {
            this.profileType = profileType;
            return this;
        }

        @Override
        public final Builder profileType(ProfileType profileType) {
            this.profileType(profileType == null ? null : profileType.toString());
            return this;
        }

        public final Collection<String> getCertificateIds() {
            if (this.certificateIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificateIds;
        }

        public final void setCertificateIds(Collection<String> certificateIds) {
            this.certificateIds = CertificateIdsCopier.copy(certificateIds);
        }

        @Override
        public final Builder certificateIds(Collection<String> certificateIds) {
            this.certificateIds = CertificateIdsCopier.copy(certificateIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateIds(String ... certificateIds) {
            this.certificateIds(Arrays.asList(certificateIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfileRequest build() {
            return new CreateProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProfileRequest> {
        public Builder as2Id(String var1);

        public Builder profileType(String var1);

        public Builder profileType(ProfileType var1);

        public Builder certificateIds(Collection<String> var1);

        public Builder certificateIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

