/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.As2Transport;
import software.amazon.awssdk.services.transfer.model.As2TransportsCopier;
import software.amazon.awssdk.services.transfer.model.SetStatOption;
import software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtocolDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtocolDetails> {
    private static final SdkField<String> PASSIVE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PassiveIp").getter(ProtocolDetails.getter(ProtocolDetails::passiveIp)).setter(ProtocolDetails.setter(Builder::passiveIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PassiveIp").build()}).build();
    private static final SdkField<String> TLS_SESSION_RESUMPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TlsSessionResumptionMode").getter(ProtocolDetails.getter(ProtocolDetails::tlsSessionResumptionModeAsString)).setter(ProtocolDetails.setter(Builder::tlsSessionResumptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsSessionResumptionMode").build()}).build();
    private static final SdkField<String> SET_STAT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SetStatOption").getter(ProtocolDetails.getter(ProtocolDetails::setStatOptionAsString)).setter(ProtocolDetails.setter(Builder::setStatOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetStatOption").build()}).build();
    private static final SdkField<List<String>> AS2_TRANSPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("As2Transports").getter(ProtocolDetails.getter(ProtocolDetails::as2TransportsAsStrings)).setter(ProtocolDetails.setter(Builder::as2TransportsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2Transports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSIVE_IP_FIELD, TLS_SESSION_RESUMPTION_MODE_FIELD, SET_STAT_OPTION_FIELD, AS2_TRANSPORTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProtocolDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String passiveIp;
    private final String tlsSessionResumptionMode;
    private final String setStatOption;
    private final List<String> as2Transports;

    private ProtocolDetails(BuilderImpl builder) {
        this.passiveIp = builder.passiveIp;
        this.tlsSessionResumptionMode = builder.tlsSessionResumptionMode;
        this.setStatOption = builder.setStatOption;
        this.as2Transports = builder.as2Transports;
    }

    public final String passiveIp() {
        return this.passiveIp;
    }

    public final TlsSessionResumptionMode tlsSessionResumptionMode() {
        return TlsSessionResumptionMode.fromValue(this.tlsSessionResumptionMode);
    }

    public final String tlsSessionResumptionModeAsString() {
        return this.tlsSessionResumptionMode;
    }

    public final SetStatOption setStatOption() {
        return SetStatOption.fromValue(this.setStatOption);
    }

    public final String setStatOptionAsString() {
        return this.setStatOption;
    }

    public final List<As2Transport> as2Transports() {
        return As2TransportsCopier.copyStringToEnum(this.as2Transports);
    }

    public final boolean hasAs2Transports() {
        return this.as2Transports != null && !(this.as2Transports instanceof SdkAutoConstructList);
    }

    public final List<String> as2TransportsAsStrings() {
        return this.as2Transports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.passiveIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsSessionResumptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.setStatOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAs2Transports() ? this.as2TransportsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolDetails)) {
            return false;
        }
        ProtocolDetails other = (ProtocolDetails)obj;
        return Objects.equals(this.passiveIp(), other.passiveIp()) && Objects.equals(this.tlsSessionResumptionModeAsString(), other.tlsSessionResumptionModeAsString()) && Objects.equals(this.setStatOptionAsString(), other.setStatOptionAsString()) && this.hasAs2Transports() == other.hasAs2Transports() && Objects.equals(this.as2TransportsAsStrings(), other.as2TransportsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ProtocolDetails").add("PassiveIp", (Object)this.passiveIp()).add("TlsSessionResumptionMode", (Object)this.tlsSessionResumptionModeAsString()).add("SetStatOption", (Object)this.setStatOptionAsString()).add("As2Transports", this.hasAs2Transports() ? this.as2TransportsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PassiveIp": {
                return Optional.ofNullable(clazz.cast(this.passiveIp()));
            }
            case "TlsSessionResumptionMode": {
                return Optional.ofNullable(clazz.cast(this.tlsSessionResumptionModeAsString()));
            }
            case "SetStatOption": {
                return Optional.ofNullable(clazz.cast(this.setStatOptionAsString()));
            }
            case "As2Transports": {
                return Optional.ofNullable(clazz.cast(this.as2TransportsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PassiveIp", PASSIVE_IP_FIELD);
        map.put("TlsSessionResumptionMode", TLS_SESSION_RESUMPTION_MODE_FIELD);
        map.put("SetStatOption", SET_STAT_OPTION_FIELD);
        map.put("As2Transports", AS2_TRANSPORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtocolDetails, T> g) {
        return obj -> g.apply((ProtocolDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String passiveIp;
        private String tlsSessionResumptionMode;
        private String setStatOption;
        private List<String> as2Transports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtocolDetails model) {
            this.passiveIp(model.passiveIp);
            this.tlsSessionResumptionMode(model.tlsSessionResumptionMode);
            this.setStatOption(model.setStatOption);
            this.as2TransportsWithStrings(model.as2Transports);
        }

        public final String getPassiveIp() {
            return this.passiveIp;
        }

        public final void setPassiveIp(String passiveIp) {
            this.passiveIp = passiveIp;
        }

        @Override
        public final Builder passiveIp(String passiveIp) {
            this.passiveIp = passiveIp;
            return this;
        }

        public final String getTlsSessionResumptionMode() {
            return this.tlsSessionResumptionMode;
        }

        public final void setTlsSessionResumptionMode(String tlsSessionResumptionMode) {
            this.tlsSessionResumptionMode = tlsSessionResumptionMode;
        }

        @Override
        public final Builder tlsSessionResumptionMode(String tlsSessionResumptionMode) {
            this.tlsSessionResumptionMode = tlsSessionResumptionMode;
            return this;
        }

        @Override
        public final Builder tlsSessionResumptionMode(TlsSessionResumptionMode tlsSessionResumptionMode) {
            this.tlsSessionResumptionMode(tlsSessionResumptionMode == null ? null : tlsSessionResumptionMode.toString());
            return this;
        }

        public final String getSetStatOption() {
            return this.setStatOption;
        }

        public final void setSetStatOption(String setStatOption) {
            this.setStatOption = setStatOption;
        }

        @Override
        @Transient
        public final Builder setStatOption(String setStatOption) {
            this.setStatOption = setStatOption;
            return this;
        }

        @Override
        @Transient
        public final Builder setStatOption(SetStatOption setStatOption) {
            this.setStatOption(setStatOption == null ? null : setStatOption.toString());
            return this;
        }

        public final Collection<String> getAs2Transports() {
            if (this.as2Transports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.as2Transports;
        }

        public final void setAs2Transports(Collection<String> as2Transports) {
            this.as2Transports = As2TransportsCopier.copy(as2Transports);
        }

        @Override
        public final Builder as2TransportsWithStrings(Collection<String> as2Transports) {
            this.as2Transports = As2TransportsCopier.copy(as2Transports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder as2TransportsWithStrings(String ... as2Transports) {
            this.as2TransportsWithStrings(Arrays.asList(as2Transports));
            return this;
        }

        @Override
        public final Builder as2Transports(Collection<As2Transport> as2Transports) {
            this.as2Transports = As2TransportsCopier.copyEnumToString(as2Transports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder as2Transports(As2Transport ... as2Transports) {
            this.as2Transports(Arrays.asList(as2Transports));
            return this;
        }

        public ProtocolDetails build() {
            return new ProtocolDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtocolDetails> {
        public Builder passiveIp(String var1);

        public Builder tlsSessionResumptionMode(String var1);

        public Builder tlsSessionResumptionMode(TlsSessionResumptionMode var1);

        public Builder setStatOption(String var1);

        public Builder setStatOption(SetStatOption var1);

        public Builder as2TransportsWithStrings(Collection<String> var1);

        public Builder as2TransportsWithStrings(String ... var1);

        public Builder as2Transports(Collection<As2Transport> var1);

        public Builder as2Transports(As2Transport ... var1);
    }
}

