/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceConfigurationStatus {
    ACTIVE("ACTIVE"),
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    UPDATE_IN_PROGRESS("UPDATE_IN_PROGRESS"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    CREATE_FAILED("CREATE_FAILED"),
    UPDATE_FAILED("UPDATE_FAILED"),
    DELETE_FAILED("DELETE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceConfigurationStatus> VALUE_MAP;
    private final String value;

    private ResourceConfigurationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceConfigurationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceConfigurationStatus> knownValues() {
        EnumSet<ResourceConfigurationStatus> knownValues = EnumSet.allOf(ResourceConfigurationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceConfigurationStatus.class, ResourceConfigurationStatus::toString);
    }
}

