/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.All;
import software.amazon.awssdk.services.wafv2.model.HeaderNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HeaderMatchPattern
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HeaderMatchPattern> {
    private static final SdkField<All> ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("All").getter(HeaderMatchPattern.getter(HeaderMatchPattern::all)).setter(HeaderMatchPattern.setter(Builder::all)).constructor(All::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("All").build()}).build();
    private static final SdkField<List<String>> INCLUDED_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedHeaders").getter(HeaderMatchPattern.getter(HeaderMatchPattern::includedHeaders)).setter(HeaderMatchPattern.setter(Builder::includedHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedHeaders").getter(HeaderMatchPattern.getter(HeaderMatchPattern::excludedHeaders)).setter(HeaderMatchPattern.setter(Builder::excludedHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_FIELD, INCLUDED_HEADERS_FIELD, EXCLUDED_HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HeaderMatchPattern.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final All all;
    private final List<String> includedHeaders;
    private final List<String> excludedHeaders;

    private HeaderMatchPattern(BuilderImpl builder) {
        this.all = builder.all;
        this.includedHeaders = builder.includedHeaders;
        this.excludedHeaders = builder.excludedHeaders;
    }

    public final All all() {
        return this.all;
    }

    public final boolean hasIncludedHeaders() {
        return this.includedHeaders != null && !(this.includedHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> includedHeaders() {
        return this.includedHeaders;
    }

    public final boolean hasExcludedHeaders() {
        return this.excludedHeaders != null && !(this.excludedHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> excludedHeaders() {
        return this.excludedHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.all());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedHeaders() ? this.includedHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedHeaders() ? this.excludedHeaders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeaderMatchPattern)) {
            return false;
        }
        HeaderMatchPattern other = (HeaderMatchPattern)obj;
        return Objects.equals(this.all(), other.all()) && this.hasIncludedHeaders() == other.hasIncludedHeaders() && Objects.equals(this.includedHeaders(), other.includedHeaders()) && this.hasExcludedHeaders() == other.hasExcludedHeaders() && Objects.equals(this.excludedHeaders(), other.excludedHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"HeaderMatchPattern").add("All", (Object)this.all()).add("IncludedHeaders", this.hasIncludedHeaders() ? this.includedHeaders() : null).add("ExcludedHeaders", this.hasExcludedHeaders() ? this.excludedHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "All": {
                return Optional.ofNullable(clazz.cast(this.all()));
            }
            case "IncludedHeaders": {
                return Optional.ofNullable(clazz.cast(this.includedHeaders()));
            }
            case "ExcludedHeaders": {
                return Optional.ofNullable(clazz.cast(this.excludedHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("All", ALL_FIELD);
        map.put("IncludedHeaders", INCLUDED_HEADERS_FIELD);
        map.put("ExcludedHeaders", EXCLUDED_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HeaderMatchPattern, T> g) {
        return obj -> g.apply((HeaderMatchPattern)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private All all;
        private List<String> includedHeaders = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HeaderMatchPattern model) {
            this.all(model.all);
            this.includedHeaders(model.includedHeaders);
            this.excludedHeaders(model.excludedHeaders);
        }

        public final All.Builder getAll() {
            return this.all != null ? this.all.toBuilder() : null;
        }

        public final void setAll(All.BuilderImpl all) {
            this.all = all != null ? all.build() : null;
        }

        @Override
        public final Builder all(All all) {
            this.all = all;
            return this;
        }

        public final Collection<String> getIncludedHeaders() {
            if (this.includedHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includedHeaders;
        }

        public final void setIncludedHeaders(Collection<String> includedHeaders) {
            this.includedHeaders = HeaderNamesCopier.copy(includedHeaders);
        }

        @Override
        public final Builder includedHeaders(Collection<String> includedHeaders) {
            this.includedHeaders = HeaderNamesCopier.copy(includedHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedHeaders(String ... includedHeaders) {
            this.includedHeaders(Arrays.asList(includedHeaders));
            return this;
        }

        public final Collection<String> getExcludedHeaders() {
            if (this.excludedHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedHeaders;
        }

        public final void setExcludedHeaders(Collection<String> excludedHeaders) {
            this.excludedHeaders = HeaderNamesCopier.copy(excludedHeaders);
        }

        @Override
        public final Builder excludedHeaders(Collection<String> excludedHeaders) {
            this.excludedHeaders = HeaderNamesCopier.copy(excludedHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedHeaders(String ... excludedHeaders) {
            this.excludedHeaders(Arrays.asList(excludedHeaders));
            return this;
        }

        public HeaderMatchPattern build() {
            return new HeaderMatchPattern(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HeaderMatchPattern> {
        public Builder all(All var1);

        default public Builder all(Consumer<All.Builder> all) {
            return this.all((All)((All.Builder)All.builder().applyMutation(all)).build());
        }

        public Builder includedHeaders(Collection<String> var1);

        public Builder includedHeaders(String ... var1);

        public Builder excludedHeaders(Collection<String> var1);

        public Builder excludedHeaders(String ... var1);
    }
}

