/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wisdom.model.RecommendationIdListCopier;
import software.amazon.awssdk.services.wisdom.model.WisdomRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotifyRecommendationsReceivedRequest
extends WisdomRequest
implements ToCopyableBuilder<Builder, NotifyRecommendationsReceivedRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(NotifyRecommendationsReceivedRequest.getter(NotifyRecommendationsReceivedRequest::assistantId)).setter(NotifyRecommendationsReceivedRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationIds").getter(NotifyRecommendationsReceivedRequest.getter(NotifyRecommendationsReceivedRequest::recommendationIds)).setter(NotifyRecommendationsReceivedRequest.setter(Builder::recommendationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(NotifyRecommendationsReceivedRequest.getter(NotifyRecommendationsReceivedRequest::sessionId)).setter(NotifyRecommendationsReceivedRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, RECOMMENDATION_IDS_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotifyRecommendationsReceivedRequest.memberNameToFieldInitializer();
    private final String assistantId;
    private final List<String> recommendationIds;
    private final String sessionId;

    private NotifyRecommendationsReceivedRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.recommendationIds = builder.recommendationIds;
        this.sessionId = builder.sessionId;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final boolean hasRecommendationIds() {
        return this.recommendationIds != null && !(this.recommendationIds instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationIds() {
        return this.recommendationIds;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationIds() ? this.recommendationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyRecommendationsReceivedRequest)) {
            return false;
        }
        NotifyRecommendationsReceivedRequest other = (NotifyRecommendationsReceivedRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && this.hasRecommendationIds() == other.hasRecommendationIds() && Objects.equals(this.recommendationIds(), other.recommendationIds()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"NotifyRecommendationsReceivedRequest").add("AssistantId", (Object)this.assistantId()).add("RecommendationIds", this.hasRecommendationIds() ? this.recommendationIds() : null).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "recommendationIds": {
                return Optional.ofNullable(clazz.cast(this.recommendationIds()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("recommendationIds", RECOMMENDATION_IDS_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotifyRecommendationsReceivedRequest, T> g) {
        return obj -> g.apply((NotifyRecommendationsReceivedRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private List<String> recommendationIds = DefaultSdkAutoConstructList.getInstance();
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyRecommendationsReceivedRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.recommendationIds(model.recommendationIds);
            this.sessionId(model.sessionId);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final Collection<String> getRecommendationIds() {
            if (this.recommendationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationIds;
        }

        public final void setRecommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
        }

        @Override
        public final Builder recommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationIds(String ... recommendationIds) {
            this.recommendationIds(Arrays.asList(recommendationIds));
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public NotifyRecommendationsReceivedRequest build() {
            return new NotifyRecommendationsReceivedRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WisdomRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, NotifyRecommendationsReceivedRequest> {
        public Builder assistantId(String var1);

        public Builder recommendationIds(Collection<String> var1);

        public Builder recommendationIds(String ... var1);

        public Builder sessionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

