/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteOrganizationRequest extends WorkMailRequest implements
        ToCopyableBuilder<DeleteOrganizationRequest.Builder, DeleteOrganizationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(DeleteOrganizationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(DeleteOrganizationRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<Boolean> DELETE_DIRECTORY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteDirectory").getter(getter(DeleteOrganizationRequest::deleteDirectory))
            .setter(setter(Builder::deleteDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteDirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ORGANIZATION_ID_FIELD, DELETE_DIRECTORY_FIELD));

    private final String clientToken;

    private final String organizationId;

    private final Boolean deleteDirectory;

    private DeleteOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.organizationId = builder.organizationId;
        this.deleteDirectory = builder.deleteDirectory;
    }

    /**
     * <p>
     * The idempotency token associated with the request.
     * </p>
     * 
     * @return The idempotency token associated with the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The organization ID.
     * </p>
     * 
     * @return The organization ID.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * If true, deletes the AWS Directory Service directory associated with the organization.
     * </p>
     * 
     * @return If true, deletes the AWS Directory Service directory associated with the organization.
     */
    public final Boolean deleteDirectory() {
        return deleteDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteDirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOrganizationRequest)) {
            return false;
        }
        DeleteOrganizationRequest other = (DeleteOrganizationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(deleteDirectory(), other.deleteDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteOrganizationRequest").add("ClientToken", clientToken())
                .add("OrganizationId", organizationId()).add("DeleteDirectory", deleteDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "DeleteDirectory":
            return Optional.ofNullable(clazz.cast(deleteDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteOrganizationRequest, T> g) {
        return obj -> g.apply((DeleteOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteOrganizationRequest> {
        /**
         * <p>
         * The idempotency token associated with the request.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The organization ID.
         * </p>
         * 
         * @param organizationId
         *        The organization ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * If true, deletes the AWS Directory Service directory associated with the organization.
         * </p>
         * 
         * @param deleteDirectory
         *        If true, deletes the AWS Directory Service directory associated with the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteDirectory(Boolean deleteDirectory);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String organizationId;

        private Boolean deleteDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOrganizationRequest model) {
            super(model);
            clientToken(model.clientToken);
            organizationId(model.organizationId);
            deleteDirectory(model.deleteDirectory);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final Boolean getDeleteDirectory() {
            return deleteDirectory;
        }

        public final void setDeleteDirectory(Boolean deleteDirectory) {
            this.deleteDirectory = deleteDirectory;
        }

        @Override
        public final Builder deleteDirectory(Boolean deleteDirectory) {
            this.deleteDirectory = deleteDirectory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteOrganizationRequest build() {
            return new DeleteOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
