/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.legacy.internal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;

public class AesCtrUtils {
    public static final long MAX_GCM_BLOCKS = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherMaxContentLengthBits() >> 7;
    public static final int CIPHER_BLOCK_SIZE = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherBlockSizeBytes();

    public static byte[] adjustIV(byte[] iv, long byteOffset) {
        if (iv.length != 12) {
            throw new UnsupportedOperationException();
        }
        int blockSizeBytes = CIPHER_BLOCK_SIZE;
        long blockOffset = byteOffset / (long)blockSizeBytes;
        if (blockOffset * (long)blockSizeBytes != byteOffset) {
            throw new IllegalArgumentException("Expecting byteOffset to be multiple of 16, but got blockOffset=" + blockOffset + ", blockSize=" + blockSizeBytes + ", byteOffset=" + byteOffset);
        }
        byte[] J0 = AesCtrUtils.computeJ0(iv);
        return AesCtrUtils.incrementBlocks(J0, blockOffset);
    }

    private static byte[] computeJ0(byte[] iv) {
        int blockSizeBytes = CIPHER_BLOCK_SIZE;
        byte[] J0 = new byte[blockSizeBytes];
        System.arraycopy(iv, 0, J0, 0, iv.length);
        J0[blockSizeBytes - 1] = 1;
        return AesCtrUtils.incrementBlocks(J0, 1L);
    }

    private static byte[] incrementBlocks(byte[] counter, long blockDelta) {
        if (blockDelta == 0L) {
            return counter;
        }
        if (counter == null || counter.length != 16) {
            throw new IllegalArgumentException();
        }
        if (blockDelta > MAX_GCM_BLOCKS) {
            throw new IllegalStateException();
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        for (int i = 12; i <= 15; ++i) {
            bb.put(i - 8, counter[i]);
        }
        long val = bb.getLong() + blockDelta;
        if (val > MAX_GCM_BLOCKS) {
            throw new IllegalStateException();
        }
        ((Buffer)bb).rewind();
        byte[] result = bb.putLong(val).array();
        System.arraycopy(result, 4, counter, 12, 4);
        return counter;
    }
}

