/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryDataFormatDeserializer;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.avro.AvroDeserializer;
import com.amazonaws.services.schemaregistry.deserializers.json.JsonDeserializer;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.glue.model.DataFormat;

public class GlueSchemaRegistryDeserializerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistryDeserializerFactory.class);
    private final ConcurrentHashMap<DataFormat, GlueSchemaRegistryDataFormatDeserializer> deserializerMap = new ConcurrentHashMap();

    public GlueSchemaRegistryDataFormatDeserializer getInstance(@NonNull DataFormat dataFormat, @NonNull GlueSchemaRegistryConfiguration configs) {
        if (dataFormat == null) {
            throw new IllegalArgumentException("dataFormat is marked non-null but is null");
        }
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked non-null but is null");
        }
        switch (dataFormat) {
            case AVRO: {
                this.deserializerMap.computeIfAbsent(dataFormat, key -> AvroDeserializer.builder().configs(configs).build());
                log.debug("Returning Avro de-serializer instance from GlueSchemaRegistryDeserializerFactory");
                return this.deserializerMap.get(dataFormat);
            }
            case JSON: {
                this.deserializerMap.computeIfAbsent(dataFormat, key -> JsonDeserializer.builder().configs(configs).build());
                log.debug("Returning JSON de-serializer instance from GlueSchemaRegistryDeserializerFactory");
                return this.deserializerMap.get(dataFormat);
            }
        }
        String message = String.format("Data Format is not supported %s", dataFormat);
        throw new UnsupportedOperationException(message);
    }
}

