/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryDataFormatSerializer;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.avro.AvroSerializer;
import com.amazonaws.services.schemaregistry.serializers.json.JsonSerializer;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.glue.model.DataFormat;

public class GlueSchemaRegistrySerializerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistrySerializerFactory.class);
    private final ConcurrentHashMap<DataFormat, GlueSchemaRegistryDataFormatSerializer> serializerMap = new ConcurrentHashMap();

    public GlueSchemaRegistryDataFormatSerializer getInstance(@NonNull DataFormat dataFormat, @NonNull GlueSchemaRegistryConfiguration glueSchemaRegistryConfig) {
        if (dataFormat == null) {
            throw new IllegalArgumentException("dataFormat is marked non-null but is null");
        }
        if (glueSchemaRegistryConfig == null) {
            throw new IllegalArgumentException("glueSchemaRegistryConfig is marked non-null but is null");
        }
        switch (dataFormat) {
            case AVRO: {
                this.serializerMap.computeIfAbsent(dataFormat, key -> new AvroSerializer());
                log.debug("Returning Avro serializer instance from GlueSchemaRegistrySerializerFactory");
                return this.serializerMap.get(dataFormat);
            }
            case JSON: {
                this.serializerMap.computeIfAbsent(dataFormat, key -> new JsonSerializer(glueSchemaRegistryConfig));
                log.debug("Returning Json serializer instance from GlueSchemaRegistrySerializerFactory");
                return this.serializerMap.get(dataFormat);
            }
        }
        String message = String.format("Unsupported data format: %s", dataFormat);
        throw new AWSSchemaRegistryException(message);
    }
}

