/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.lambda.powertools.logging.internal.JsonSerializer;
import software.amazon.lambda.powertools.logging.internal.PowertoolsLoggedFields;
import software.amazon.lambda.powertools.logging.logback.JsonUtils;

public class LambdaJsonEncoder
extends EncoderBase<ILoggingEvent> {
    protected static final String TIMESTAMP_ATTR_NAME = "timestamp";
    protected static final String LEVEL_ATTR_NAME = "level";
    protected static final String FORMATTED_MESSAGE_ATTR_NAME = "message";
    protected static final String THREAD_ATTR_NAME = "thread";
    protected static final String THREAD_ID_ATTR_NAME = "thread_id";
    protected static final String THREAD_PRIORITY_ATTR_NAME = "thread_priority";
    protected static final String EXCEPTION_MSG_ATTR_NAME = "message";
    protected static final String EXCEPTION_CLASS_ATTR_NAME = "name";
    protected static final String EXCEPTION_STACK_ATTR_NAME = "stack";
    protected static final String EXCEPTION_ATTR_NAME = "error";
    private final ThrowableProxyConverter throwableProxyConverter = new ThrowableProxyConverter();
    protected ThrowableHandlingConverter throwableConverter = null;
    protected String timestampFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected String timestampFormatTimezoneId = null;
    private boolean includeThreadInfo = false;
    private boolean includePowertoolsInfo = true;

    public byte[] headerBytes() {
        return new byte[0];
    }

    public void start() {
        super.start();
        this.throwableProxyConverter.start();
        if (this.throwableConverter != null) {
            this.throwableConverter.start();
        }
    }

    public byte[] encode(ILoggingEvent event) {
        StringBuilder builder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JsonSerializer serializer = new JsonSerializer(builder);){
                serializer.writeStartObject();
                serializer.writeStringField(LEVEL_ATTR_NAME, event.getLevel().toString());
                serializer.writeRaw(',');
                serializer.writeStringField("message", event.getFormattedMessage());
                this.serializeException(event, serializer);
                TreeMap<String, String> sortedMap = new TreeMap<String, String>(event.getMDCPropertyMap());
                this.serializePowertools(sortedMap, serializer);
                JsonUtils.serializeMDCEntries(sortedMap, serializer);
                JsonUtils.serializeArguments(event, serializer);
                this.serializeThreadInfo(event, serializer);
                serializer.writeRaw(',');
                JsonUtils.serializeTimestamp(serializer, event.getTimeStamp(), this.timestampFormat, this.timestampFormatTimezoneId, TIMESTAMP_ATTR_NAME);
                serializer.writeEndObject();
                serializer.writeRaw('\n');
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.printf("Failed to encode log event, error: %s.%n", e.getMessage());
        }
        return builder.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void serializeThreadInfo(ILoggingEvent event, JsonSerializer serializer) {
        if (this.includeThreadInfo) {
            if (event.getThreadName() != null) {
                serializer.writeRaw(',');
                serializer.writeStringField(THREAD_ATTR_NAME, event.getThreadName());
            }
            serializer.writeRaw(',');
            serializer.writeNumberField(THREAD_ID_ATTR_NAME, Thread.currentThread().getId());
            serializer.writeRaw(',');
            serializer.writeNumberField(THREAD_PRIORITY_ATTR_NAME, Thread.currentThread().getPriority());
        }
    }

    private void serializePowertools(TreeMap<String, String> sortedMap, JsonSerializer serializer) {
        if (this.includePowertoolsInfo) {
            for (Map.Entry<String, String> entry : sortedMap.entrySet()) {
                if (!PowertoolsLoggedFields.stringValues().contains(entry.getKey()) || entry.getKey().equals(PowertoolsLoggedFields.SAMPLING_RATE.getName()) && entry.getValue().equals("0.0")) continue;
                JsonUtils.serializeMDCEntry(entry, serializer);
            }
        }
    }

    private void serializeException(ILoggingEvent event, JsonSerializer serializer) {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null) {
            if (this.throwableConverter != null) {
                this.serializeException(serializer, throwableProxy.getClassName(), throwableProxy.getMessage(), this.throwableConverter.convert((Object)event));
            } else if (throwableProxy instanceof ThrowableProxy) {
                Throwable throwable = ((ThrowableProxy)throwableProxy).getThrowable();
                this.serializeException(serializer, throwable.getClass().getName(), throwable.getMessage(), Arrays.toString(throwable.getStackTrace()));
            } else {
                this.serializeException(serializer, throwableProxy.getClassName(), throwableProxy.getMessage(), this.throwableProxyConverter.convert(event));
            }
        }
    }

    public byte[] footerBytes() {
        return new byte[0];
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public void setTimestampFormatTimezoneId(String timestampFormatTimezoneId) {
        this.timestampFormatTimezoneId = timestampFormatTimezoneId;
    }

    public void setThrowableConverter(ThrowableHandlingConverter throwableConverter) {
        this.throwableConverter = throwableConverter;
    }

    public void setIncludeThreadInfo(boolean includeThreadInfo) {
        this.includeThreadInfo = includeThreadInfo;
    }

    public void setIncludePowertoolsInfo(boolean includePowertoolsInfo) {
        this.includePowertoolsInfo = includePowertoolsInfo;
    }

    private void serializeException(JsonSerializer serializer, String className, String message, String stackTrace) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("message", message);
        map.put(EXCEPTION_CLASS_ATTR_NAME, className);
        map.put(EXCEPTION_STACK_ATTR_NAME, stackTrace);
        serializer.writeRaw(',');
        serializer.writeObjectField(EXCEPTION_ATTR_NAME, map);
    }
}

