/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.argument;

import java.util.Objects;
import software.amazon.lambda.powertools.logging.argument.StructuredArgument;
import software.amazon.lambda.powertools.logging.argument.StructuredArguments;
import software.amazon.lambda.powertools.logging.internal.JsonSerializer;

class KeyValueArgument
implements StructuredArgument {
    private final String key;
    private final Object value;

    public KeyValueArgument(String key, Object value) {
        this.key = Objects.requireNonNull(key, "Key must not be null");
        this.value = value;
    }

    @Override
    public void writeTo(JsonSerializer serializer) {
        serializer.writeObjectField(this.key, this.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.key) + "=" + StructuredArguments.toString(this.value);
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }
}

