/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.client;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.authentication.AuthenticationException;
import software.xdev.mockserver.client.ClientException;
import software.xdev.mockserver.client.ForwardChainExpectation;
import software.xdev.mockserver.client.MockServerClientEventBus;
import software.xdev.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import software.xdev.mockserver.configuration.ClientConfiguration;
import software.xdev.mockserver.configuration.Configuration;
import software.xdev.mockserver.formatting.StringFormatter;
import software.xdev.mockserver.httpclient.NettyHttpClient;
import software.xdev.mockserver.httpclient.SocketConnectionException;
import software.xdev.mockserver.matchers.TimeToLive;
import software.xdev.mockserver.matchers.Times;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.model.ClearType;
import software.xdev.mockserver.model.ExpectationId;
import software.xdev.mockserver.model.Format;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.HttpStatusCode;
import software.xdev.mockserver.model.LogEventRequestAndResponse;
import software.xdev.mockserver.model.MediaType;
import software.xdev.mockserver.model.PortBinding;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.model.RetrieveType;
import software.xdev.mockserver.proxyconfiguration.ProxyConfiguration;
import software.xdev.mockserver.scheduler.SchedulerThreadFactory;
import software.xdev.mockserver.serialization.ExpectationIdSerializer;
import software.xdev.mockserver.serialization.ExpectationSerializer;
import software.xdev.mockserver.serialization.LogEventRequestAndResponseSerializer;
import software.xdev.mockserver.serialization.PortBindingSerializer;
import software.xdev.mockserver.serialization.RequestDefinitionSerializer;
import software.xdev.mockserver.serialization.VerificationSequenceSerializer;
import software.xdev.mockserver.serialization.VerificationSerializer;
import software.xdev.mockserver.stop.Stoppable;
import software.xdev.mockserver.util.StringUtils;
import software.xdev.mockserver.verify.Verification;
import software.xdev.mockserver.verify.VerificationSequence;
import software.xdev.mockserver.verify.VerificationTimes;

public class MockServerClient
implements Stoppable {
    private static final Logger LOG = LoggerFactory.getLogger(MockServerClient.class);
    private static final Map<Integer, MockServerClientEventBus> EVENT_BUS_MAP = new ConcurrentHashMap<Integer, MockServerClientEventBus>();
    private static ExecutorService stopExecutorService;
    private final EventLoopGroup eventLoopGroup;
    private final String host;
    private final String contextPath;
    private final Class<MockServerClient> clientClass;
    protected CompletableFuture<Integer> portFuture;
    private Integer port;
    private HttpRequest requestOverride;
    private ClientConfiguration configuration;
    private ProxyConfiguration proxyConfiguration;
    private NettyHttpClient nettyHttpClient;
    private final RequestDefinitionSerializer requestDefinitionSerializer = new RequestDefinitionSerializer();
    private final ExpectationIdSerializer expectationIdSerializer = new ExpectationIdSerializer();
    private final LogEventRequestAndResponseSerializer httpRequestResponseSerializer = new LogEventRequestAndResponseSerializer();
    private final PortBindingSerializer portBindingSerializer = new PortBindingSerializer();
    private final ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private final VerificationSerializer verificationSerializer = new VerificationSerializer();
    private final VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();
    private final CompletableFuture<MockServerClient> stopFuture = new CompletableFuture();

    public MockServerClient(ClientConfiguration configuration, CompletableFuture<Integer> portFuture) {
        if (configuration == null) {
            configuration = ClientConfiguration.clientConfiguration();
        }
        this.clientClass = MockServerClient.class;
        this.host = "127.0.0.1";
        this.portFuture = portFuture;
        this.contextPath = "";
        this.configuration = configuration;
        this.eventLoopGroup = this.eventLoopGroup();
        LocalCallbackRegistry.setMaxWebSocketExpectations((int)configuration.maxWebSocketExpectations());
    }

    public MockServerClient(String host, int port) {
        this(host, port, "");
    }

    public MockServerClient(ClientConfiguration configuration, String host, int port) {
        this(configuration, host, port, "");
    }

    public MockServerClient(String host, int port, String contextPath) {
        this.clientClass = MockServerClient.class;
        if (StringUtils.isEmpty((String)host)) {
            throw new IllegalArgumentException("Host can not be null or empty");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("ContextPath can not be null");
        }
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
        this.configuration = ClientConfiguration.clientConfiguration();
        this.eventLoopGroup = this.eventLoopGroup();
        LocalCallbackRegistry.setMaxWebSocketExpectations((int)this.configuration.maxWebSocketExpectations());
    }

    public MockServerClient(ClientConfiguration configuration, String host, int port, String contextPath) {
        this.clientClass = MockServerClient.class;
        if (StringUtils.isEmpty((String)host)) {
            throw new IllegalArgumentException("Host can not be null or empty");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("ContextPath can not be null");
        }
        if (configuration == null) {
            configuration = ClientConfiguration.clientConfiguration();
        }
        this.configuration = configuration;
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
        this.eventLoopGroup = this.eventLoopGroup();
    }

    private IoEventLoopGroup eventLoopGroup() {
        return new MultiThreadIoEventLoopGroup(this.configuration.clientNioEventLoopThreadCount().intValue(), (ThreadFactory)new SchedulerThreadFactory(this.getClass().getSimpleName() + "-eventLoop"), NioIoHandler.newFactory());
    }

    public MockServerClient withProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        return this;
    }

    public MockServerClient withRequestOverride(HttpRequest requestOverride) {
        if (requestOverride == null) {
            throw new IllegalArgumentException("Request with default properties can not be null");
        }
        this.requestOverride = requestOverride;
        return this;
    }

    private MockServerClientEventBus getMockServerEventBus() {
        if (EVENT_BUS_MAP.get(this.port()) == null) {
            EVENT_BUS_MAP.put(this.port(), new MockServerClientEventBus());
        }
        return EVENT_BUS_MAP.get(this.port());
    }

    private void removeMockServerEventBus() {
        EVENT_BUS_MAP.remove(this.port());
    }

    private int port() {
        if (this.port == null) {
            try {
                this.port = this.portFuture.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.port;
    }

    public InetSocketAddress remoteAddress() {
        return new InetSocketAddress(this.host, this.port());
    }

    public String contextPath() {
        return this.contextPath;
    }

    public Integer getPort() {
        return this.port();
    }

    private String calculatePath(String path) {
        String cleanedPath = "/mockserver/" + path;
        if (StringUtils.isNotBlank((String)this.contextPath)) {
            cleanedPath = (!this.contextPath.startsWith("/") ? "/" : "") + this.contextPath + (!this.contextPath.endsWith("/") ? "/" : "") + (String)(cleanedPath.startsWith("/") ? cleanedPath.substring(1) : cleanedPath);
        }
        return (!cleanedPath.startsWith("/") ? "/" : "") + cleanedPath;
    }

    private NettyHttpClient getNettyHttpClient() {
        if (this.nettyHttpClient == null) {
            this.nettyHttpClient = new NettyHttpClient((Configuration)this.configuration, this.eventLoopGroup, this.proxyConfiguration != null ? List.of(this.proxyConfiguration) : null, false);
        }
        return this.nettyHttpClient;
    }

    private HttpResponse sendRequest(HttpRequest request, boolean ignoreErrors, boolean throwClientException) {
        if (!this.stopFuture.isDone()) {
            try {
                HttpResponse response;
                if (!request.containsHeader(HttpHeaderNames.CONTENT_TYPE.toString()) && request.getBody() != null && StringUtils.isNotBlank((String)request.getBody().getContentType())) {
                    request.withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{request.getBody().getContentType()});
                }
                if (this.requestOverride != null) {
                    request = request.update(this.requestOverride, null);
                }
                if ((response = this.getNettyHttpClient().sendRequest(request.withHeader(HttpHeaderNames.HOST.toString(), new String[]{this.host + ":" + this.port()}), this.configuration.maxSocketTimeoutInMillis().longValue(), TimeUnit.MILLISECONDS, ignoreErrors)) != null && response.getStatusCode() != null) {
                    if (response.getStatusCode().intValue() == HttpResponseStatus.BAD_REQUEST.code()) {
                        throw new IllegalArgumentException(response.getBodyAsString());
                    }
                    if (response.getStatusCode().intValue() == HttpResponseStatus.UNAUTHORIZED.code()) {
                        throw new AuthenticationException(response.getBodyAsString());
                    }
                }
                if (throwClientException && response != null && response.getStatusCode() != null && response.getStatusCode() >= 400) {
                    throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while sending request:{}", (Object[])new Object[]{response, request}));
                }
                return response;
            }
            catch (RuntimeException rex) {
                if (StringUtils.isNotBlank((String)rex.getMessage()) && (rex.getMessage().contains("executor not accepting a task") || rex.getMessage().contains("loop shut down"))) {
                    throw new IllegalStateException(this.getClass().getSimpleName() + " has already been closed, please create new " + this.getClass().getSimpleName() + " instance", rex);
                }
                throw rex;
            }
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " has already been stopped, please create new " + this.getClass().getSimpleName() + " instance");
    }

    private HttpResponse sendRequest(HttpRequest request, boolean throwClientException) {
        return this.sendRequest(request, false, throwClientException);
    }

    public boolean hasStopped() {
        return this.hasStopped(10, 500L, TimeUnit.MILLISECONDS);
    }

    public boolean hasStopped(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")), true, false);
            if (httpResponse != null && httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                if (attempts <= 0) {
                    return false;
                }
                try {
                    timeUnit.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.hasStopped(attempts - 1, timeout, timeUnit);
            }
            return true;
        }
        catch (IllegalStateException | SocketConnectionException sce) {
            return true;
        }
    }

    public boolean hasStarted() {
        return this.hasStarted(10, 500L, TimeUnit.MILLISECONDS);
    }

    public boolean hasStarted(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")), false);
            if (httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                return true;
            }
            if (attempts <= 0) {
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.hasStarted(attempts - 1, timeout, timeUnit);
        }
        catch (IllegalStateException | SocketConnectionException sce) {
            if (attempts <= 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception while checking if MockServer has started", sce);
                }
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.hasStarted(attempts - 1, timeout, timeUnit);
        }
    }

    public List<Integer> bind(Integer ... ports) {
        String boundPorts = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("bind")).withBody(this.portBindingSerializer.serialize(PortBinding.portBinding((Integer[])ports)), StandardCharsets.UTF_8), true).getBodyAsString();
        return this.portBindingSerializer.deserialize(boundPorts).getPorts();
    }

    public Future<MockServerClient> stopAsync() {
        return this.stop(true);
    }

    public void stop() {
        block2: {
            try {
                this.stopAsync().get(10L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Exception while stopping", (Throwable)ex);
            }
        }
    }

    public CompletableFuture<MockServerClient> stop(boolean ignoreFailure) {
        if (this.stopFuture.isDone()) {
            return this.stopFuture;
        }
        this.getMockServerEventBus().publish(MockServerClientEventBus.EventType.STOP);
        this.removeMockServerEventBus();
        CompletableFuture.runAsync(() -> {
            block7: {
                try {
                    this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("stop")), false);
                    if (!this.hasStopped()) {
                        for (int i = 0; !this.hasStopped() && i < 50; ++i) {
                            TimeUnit.MILLISECONDS.sleep(5L);
                        }
                    }
                }
                catch (RejectedExecutionException ree) {
                    if (!ignoreFailure && LOG.isTraceEnabled()) {
                        LOG.trace("Request rejected while closing down, logging in case due other error", (Throwable)ree);
                    }
                }
                catch (Exception e) {
                    if (ignoreFailure) break block7;
                    LOG.trace("Failed to send stop request to MockServer", (Throwable)e);
                }
            }
            if (!this.eventLoopGroup.isShuttingDown()) {
                this.eventLoopGroup.shutdownGracefully();
            }
            this.stopFuture.complete(this.clientClass.cast(this));
        }, MockServerClient.stopExecutorService());
        return this.stopFuture;
    }

    protected static ExecutorService stopExecutorService() {
        if (stopExecutorService == null) {
            stopExecutorService = Executors.newCachedThreadPool((ThreadFactory)new SchedulerThreadFactory("ClientStop"));
        }
        return stopExecutorService;
    }

    public void close() {
        this.stop();
    }

    public MockServerClient reset() {
        this.getMockServerEventBus().publish(MockServerClientEventBus.EventType.RESET);
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("reset")), true);
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(RequestDefinition requestDefinition) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("clear")).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8), true);
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(String expectationId) {
        return this.clear(ExpectationId.expectationId((String)expectationId));
    }

    public MockServerClient clear(ExpectationId expectationId) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("clear")).withBody(expectationId != null ? this.expectationIdSerializer.serialize(expectationId) : "", StandardCharsets.UTF_8), true);
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(RequestDefinition requestDefinition, ClearType type) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("clear")).withQueryStringParameter("type", new String[]{type.name().toLowerCase()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8), true);
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(String expectationId, ClearType type) {
        return this.clear(ExpectationId.expectationId((String)expectationId), type);
    }

    public MockServerClient clear(ExpectationId expectationId, ClearType type) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("clear")).withQueryStringParameter("type", new String[]{type.name().toLowerCase()}).withBody(expectationId != null ? this.expectationIdSerializer.serialize(expectationId) : "", StandardCharsets.UTF_8), true);
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(RequestDefinition ... requestDefinitions) throws AssertionError {
        return this.verify((Integer)null, requestDefinitions);
    }

    public MockServerClient verify(Integer maximumNumberOfRequestToReturnInVerificationFailure, RequestDefinition ... requestDefinitions) throws AssertionError {
        if (requestDefinitions == null || requestDefinitions.length == 0 || requestDefinitions[0] == null) {
            throw new IllegalArgumentException("verify(RequestDefinition...) requires a non-null non-empty array of RequestDefinition objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withRequests(requestDefinitions).withMaximumNumberOfRequestToReturnInVerificationFailure(maximumNumberOfRequestToReturnInVerificationFailure);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence), StandardCharsets.UTF_8), false).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new IllegalStateException(result);
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(String ... expectationIds) throws AssertionError {
        return this.verify((ExpectationId[])Arrays.stream(expectationIds).map(ExpectationId::expectationId).toArray(ExpectationId[]::new));
    }

    public MockServerClient verify(ExpectationId ... expectationIds) throws AssertionError {
        return this.verify((Integer)null, expectationIds);
    }

    public MockServerClient verify(Integer maximumNumberOfRequestToReturnInVerificationFailure, ExpectationId ... expectationIds) throws AssertionError {
        if (expectationIds == null || expectationIds.length == 0 || expectationIds[0] == null) {
            throw new IllegalArgumentException("verify(ExpectationId...) requires a non-null non-empty array of ExpectationId objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withExpectationIds(expectationIds).withMaximumNumberOfRequestToReturnInVerificationFailure(maximumNumberOfRequestToReturnInVerificationFailure);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence), StandardCharsets.UTF_8), false).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new IllegalStateException(result);
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(RequestDefinition requestDefinition, VerificationTimes times) throws AssertionError {
        return this.verify(requestDefinition, times, null);
    }

    public MockServerClient verify(RequestDefinition requestDefinition, VerificationTimes times, Integer maximumNumberOfRequestToReturnInVerificationFailure) throws AssertionError {
        if (requestDefinition == null) {
            throw new IllegalArgumentException("verify(RequestDefinition, VerificationTimes) requires a non null RequestDefinition object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(RequestDefinition, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = Verification.verification().withRequest(requestDefinition).withTimes(times).withMaximumNumberOfRequestToReturnInVerificationFailure(maximumNumberOfRequestToReturnInVerificationFailure);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), StandardCharsets.UTF_8), false).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new IllegalStateException(result);
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(String expectationId, VerificationTimes times) throws AssertionError {
        return this.verify(ExpectationId.expectationId((String)expectationId), times);
    }

    public MockServerClient verify(ExpectationId expectationId, VerificationTimes times) throws AssertionError {
        return this.verify(expectationId, times, null);
    }

    public MockServerClient verify(ExpectationId expectationId, VerificationTimes times, Integer maximumNumberOfRequestToReturnInVerificationFailure) throws AssertionError {
        if (expectationId == null) {
            throw new IllegalArgumentException("verify(ExpectationId, VerificationTimes) requires a non null ExpectationId object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(ExpectationId, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = Verification.verification().withExpectationId(expectationId).withTimes(times).withMaximumNumberOfRequestToReturnInVerificationFailure(maximumNumberOfRequestToReturnInVerificationFailure);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), StandardCharsets.UTF_8), false).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new IllegalStateException(result);
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verifyZeroInteractions() throws AssertionError {
        Verification verification = Verification.verification().withRequest((RequestDefinition)HttpRequest.request()).withTimes(VerificationTimes.exactly((int)0));
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), StandardCharsets.UTF_8), false).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new IllegalStateException(result);
        }
        return this.clientClass.cast(this);
    }

    public HttpRequest[] retrieveRecordedRequests(RequestDefinition requestDefinition) {
        RequestDefinition[] requestDefinitions = new RequestDefinition[]{};
        String recordedRequests = this.retrieveRecordedRequests(requestDefinition, Format.JSON);
        if (StringUtils.isNotBlank((String)recordedRequests) && !"[]".equals(recordedRequests)) {
            requestDefinitions = this.requestDefinitionSerializer.deserializeArray(recordedRequests);
        }
        return (HttpRequest[])Arrays.stream(requestDefinitions).map(HttpRequest.class::cast).toArray(HttpRequest[]::new);
    }

    public String retrieveRecordedRequests(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.REQUESTS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8), true);
        return httpResponse.getBodyAsString();
    }

    public LogEventRequestAndResponse[] retrieveRecordedRequestsAndResponses(RequestDefinition requestDefinition) {
        String recordedRequests = this.retrieveRecordedRequestsAndResponses(requestDefinition, Format.JSON);
        if (StringUtils.isNotBlank((String)recordedRequests) && !"[]".equals(recordedRequests)) {
            return this.httpRequestResponseSerializer.deserializeArray(recordedRequests);
        }
        return new LogEventRequestAndResponse[0];
    }

    public String retrieveRecordedRequestsAndResponses(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.REQUEST_RESPONSES.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8), true);
        return httpResponse.getBodyAsString();
    }

    public Expectation[] retrieveRecordedExpectations(RequestDefinition requestDefinition) {
        String recordedExpectations = this.retrieveRecordedExpectations(requestDefinition, Format.JSON);
        if (StringUtils.isNotBlank((String)recordedExpectations) && !"[]".equals(recordedExpectations)) {
            return this.expectationSerializer.deserializeArray(recordedExpectations, true);
        }
        return new Expectation[0];
    }

    public String retrieveRecordedExpectations(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.RECORDED_EXPECTATIONS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8), true);
        return httpResponse.getBodyAsString();
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition) {
        return this.when(requestDefinition, Times.unlimited());
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition, Times times) {
        return new ForwardChainExpectation(this.configuration, this.getMockServerEventBus(), this, new Expectation(requestDefinition, times, TimeToLive.unlimited(), 0));
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition, Times times, TimeToLive timeToLive) {
        return new ForwardChainExpectation(this.configuration, this.getMockServerEventBus(), this, new Expectation(requestDefinition, times, timeToLive, 0));
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition, Times times, TimeToLive timeToLive, Integer priority) {
        return new ForwardChainExpectation(this.configuration, this.getMockServerEventBus(), this, new Expectation(requestDefinition, times, timeToLive, priority.intValue()));
    }

    public Expectation[] upsert(Expectation ... expectations) {
        if (expectations != null) {
            HttpResponse httpResponse = null;
            if (expectations.length == 1) {
                httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("expectation")).withBody(this.expectationSerializer.serialize(expectations[0]), StandardCharsets.UTF_8), false);
                if (httpResponse != null && httpResponse.getStatusCode() != 201) {
                    throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted expectation:{}", (Object[])new Object[]{httpResponse, expectations[0]}));
                }
            } else if (expectations.length > 1 && (httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("expectation")).withBody(this.expectationSerializer.serialize(expectations), StandardCharsets.UTF_8), false)) != null && httpResponse.getStatusCode() != 201) {
                throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted expectations:{}", (Object[])new Object[]{httpResponse, expectations}));
            }
            if (httpResponse != null && StringUtils.isNotBlank((String)httpResponse.getBodyAsString())) {
                return this.expectationSerializer.deserializeArray(httpResponse.getBodyAsString(), true);
            }
        }
        return new Expectation[0];
    }

    public Expectation[] retrieveActiveExpectations(RequestDefinition requestDefinition) {
        String activeExpectations = this.retrieveActiveExpectations(requestDefinition, Format.JSON);
        if (StringUtils.isNotBlank((String)activeExpectations) && !"[]".equals(activeExpectations)) {
            return this.expectationSerializer.deserializeArray(activeExpectations, true);
        }
        return new Expectation[0];
    }

    public String retrieveActiveExpectations(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.ACTIVE_EXPECTATIONS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8), false);
        return httpResponse.getBodyAsString();
    }
}

