/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.mockserver.containers;

import java.util.Optional;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import software.xdev.testcontainers.mockserver.containers.MockServerUtils;

public class MockServerContainer
extends GenericContainer<MockServerContainer> {
    public static final String DEFAULT_IMAGE = "xdevsoftware/mockserver";
    public static final String DEFAULT_TAG = "latest";
    public static final int PORT = 1080;

    public MockServerContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*started on port: 1080.*", (int)1));
        this.addExposedPort(1080);
    }

    public MockServerContainer(String tag) {
        this(DockerImageName.parse((String)(DEFAULT_IMAGE + Optional.ofNullable(tag).map(s -> ":" + s).orElse(""))));
    }

    public MockServerContainer() {
        this(MockServerUtils.getClasspathMockserverVersion());
    }

    public MockServerContainer withArgOverride(String args) {
        return (MockServerContainer)this.withEnv("ARGS", args);
    }

    public String getEndpoint() {
        return String.format("http://%s:%d", this.getHost(), this.getServerPort());
    }

    public String getSecureEndpoint() {
        return String.format("https://%s:%d", this.getHost(), this.getServerPort());
    }

    public int getServerPort() {
        return this.getMappedPort(1080);
    }
}

