/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.angular.security.oauth2.domain;

import java.util.regex.Pattern;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.packagejson.VersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacements;
import tech.jhipster.lite.module.domain.replacement.RegexReplacer;

public class AngularOauth2ModuleFactory {
    private static final String APP_MODULE_IMPORTS = "import { LoginComponent } from './login/login.component';\nimport { Oauth2AuthService } from './auth/oauth2-auth.service';\nimport { HttpAuthInterceptor } from './auth/http-auth.interceptor';\n";
    private static final String INIT_APP_METHOD = "const initializeApp = (oauth2AuthService: Oauth2AuthService) => {\n  return () => {\n    oauth2AuthService.initAuthentication();\n  };\n};\n";
    private static final ElementReplacer ANGULAR_CORE_IMPORT_NEEDLE = JHipsterModule.regex("\\} +from +['\"]@angular/core['\"];");
    private static final String APP_INITIALIZER_IMPORT = ", APP_INITIALIZER } from '@angular/core';";
    private static final ElementReplacer DECORATOR_NEEDLE = JHipsterModule.lineBeforeRegex("@[A-Z]{1}[\\w]+\\(\\{");
    private static final Pattern PROVIDERS_PATTERN = Pattern.compile("(providers: *\\[)");
    private static final ElementReplacer EXISTING_PROVIDERS_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> PROVIDERS_PATTERN.matcher(contentBeforeReplacement).find(), PROVIDERS_PATTERN);
    private static final ElementReplacer NEW_PROVIDERS_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> !PROVIDERS_PATTERN.matcher(contentBeforeReplacement).find(), "(declarations: *\\[[^]]*\\] *,)");
    private static final String PROVIDERS = "{ provide: APP_INITIALIZER, useFactory: initializeApp, multi: true, deps: [Oauth2AuthService] },\n{ provide: HTTP_INTERCEPTORS, useClass: HttpAuthInterceptor, multi: true, },\n";
    private static final ElementReplacer DECLARATIONS_NEEDLE = JHipsterModule.regex("(declarations: *\\[)");
    private static final ElementReplacer ENVIRONMENT_NEEDLE = JHipsterModule.lineAfterRegex("export const environment *= *\\{");
    private static final String KEYCLOAK_ENVIRONMENT = "keycloak: {\n  url: 'http://localhost:9080',\n  realm: 'jhipster',\n  client_id: 'web_app'\n},\n";
    private static final Pattern EMPTY_ALLOWED_COMMON_DEPENDENCIES_PATTERN = Pattern.compile("(\"allowedCommonJsDependencies\": *\\[\\s*)\\]");
    private static final ElementReplacer EMPTY_ALLOWED_COMMON_DEPENDENCIES_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> EMPTY_ALLOWED_COMMON_DEPENDENCIES_PATTERN.matcher(contentBeforeReplacement).find(), EMPTY_ALLOWED_COMMON_DEPENDENCIES_PATTERN);
    private static final Pattern FILLED_ALLOWED_COMMON_DEPENDENCIES_PATTERN = Pattern.compile("(\"allowedCommonJsDependencies\": *\\[[^]]+)\\]");
    private static final ElementReplacer FILLED_ALLOWED_COMMON_DEPENDENCIES_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> FILLED_ALLOWED_COMMON_DEPENDENCIES_PATTERN.matcher(contentBeforeReplacement).find(), FILLED_ALLOWED_COMMON_DEPENDENCIES_PATTERN);
    private static final ElementReplacer MENU_NEEDLE = JHipsterModule.lineAfterRegex("<span.+id=\\\"menu-space-separator\\\".*></span>");
    private static final String TEST_IMPORTS = "import { By } from '@angular/platform-browser';\nimport { LoginComponent } from './login/login.component';\n";
    private static final ElementReplacer TEST_NEEDLE = JHipsterModule.lineAfterRegex("^\\s+it\\('should have appName',[^}]+\\}\\);");
    private static final String LOGIN_COMPONENT_TEST = "\nit('should display login component', () => {\n  fixture.detectChanges();\n\n  expect(fixture.debugElement.query(By.directive(LoginComponent))).toBeTruthy();\n});\n";
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/angular/security/oauth2/src/main/webapp/app");
    private static final JHipsterDestination APP_DESTINATION = JHipsterModule.to("src/main/webapp/app");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        Indentation indentation = properties.indentation();
        return ((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)JHipsterModule.moduleBuilder(properties).packageJson().addDependency(JHipsterModule.packageName("keycloak-js"), VersionSource.ANGULAR).and().files().batch(SOURCE.append("auth"), APP_DESTINATION.append("auth")).addFile("oauth2-auth.service.ts").addFile("oauth2-auth.service.spec.ts").addFile("http-auth.interceptor.ts").addFile("http-auth.interceptor.spec.ts").and().batch(SOURCE.append("login"), APP_DESTINATION.append("login")).addFile("login.component.html").addFile("login.component.ts").addFile("login.component.spec.ts").and().and().mandatoryReplacements().in(JHipsterModule.path("src/main/webapp/app/app.module.ts")).add(JHipsterModule.fileStart(), APP_MODULE_IMPORTS)).add(ANGULAR_CORE_IMPORT_NEEDLE, APP_INITIALIZER_IMPORT)).add(DECORATOR_NEEDLE, INIT_APP_METHOD)).add(DECLARATIONS_NEEDLE, "$1LoginComponent, ")).add(EXISTING_PROVIDERS_NEEDLE, this.existingProviders(indentation))).add(NEW_PROVIDERS_NEEDLE, this.newProviders(indentation))).and()).in(JHipsterModule.path("src/main/webapp/environments/environment.ts")).add(ENVIRONMENT_NEEDLE, this.keycloakEnvironment(indentation))).and()).in(JHipsterModule.path("src/main/webapp/environments/environment.prod.ts")).add(ENVIRONMENT_NEEDLE, this.keycloakEnvironment(indentation))).and()).in(JHipsterModule.path("angular.json")).add(FILLED_ALLOWED_COMMON_DEPENDENCIES_NEEDLE, "$1, \"keycloak-js\"]")).add(EMPTY_ALLOWED_COMMON_DEPENDENCIES_NEEDLE, "$1\"keycloak-js\"]")).and()).in(JHipsterModule.path("src/main/webapp/app/app.component.html")).add(MENU_NEEDLE, indentation.spaces() + "<jhi-login></jhi-login>")).and()).in(JHipsterModule.path("src/main/webapp/app/app.component.spec.ts")).add(JHipsterModule.fileStart(), TEST_IMPORTS)).add(DECLARATIONS_NEEDLE, "$1LoginComponent, ")).add(TEST_NEEDLE, LOGIN_COMPONENT_TEST.indent(indentation.spacesCount() * 2))).and()).and().build();
    }

    private String existingProviders(Indentation indentation) {
        return "$1" + "\n" + PROVIDERS.indent(indentation.spacesCount() * 2) + indentation.times(2);
    }

    private String newProviders(Indentation indentation) {
        return "$1" + "\n" + indentation.spaces() + "providers: [" + "\n" + PROVIDERS.indent(indentation.spacesCount() * 2) + "],";
    }

    private String keycloakEnvironment(Indentation indentation) {
        return KEYCLOAK_ENVIRONMENT.indent(indentation.spacesCount());
    }
}

