/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.technicaltools.actuator.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class SpringBootActuatorModuleFactory {
    private static final GroupId SPRING_GROUP = JHipsterModule.groupId("org.springframework.boot");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        JHipsterModule.JHipsterModuleBuilder builder = JHipsterModule.moduleBuilder(properties).context().put("applicationName", properties.projectBaseName().capitalized()).and();
        this.appendDependencies(builder);
        this.appendSpringProperties(builder);
        return builder.build();
    }

    private void appendDependencies(JHipsterModule.JHipsterModuleBuilder builder) {
        builder.javaDependencies().addDependency(SPRING_GROUP, JHipsterModule.artifactId("spring-boot-starter-actuator"));
    }

    private void appendSpringProperties(JHipsterModule.JHipsterModuleBuilder builder) {
        builder.springMainProperties().set(JHipsterModule.propertyKey("management.endpoints.web.base-path"), JHipsterModule.propertyValue("/management")).set(JHipsterModule.propertyKey("management.endpoints.web.exposure.include"), JHipsterModule.propertyValue("configprops", "env", "health", "info", "logfile", "loggers", "threaddump")).set(JHipsterModule.propertyKey("management.endpoint.health.probes.enabled"), JHipsterModule.propertyValue("true")).set(JHipsterModule.propertyKey("spring.security.oauth2.client.registration.oidc.scope"), JHipsterModule.propertyValue("openid", "profile", "email")).set(JHipsterModule.propertyKey("management.endpoint.health.show-details"), JHipsterModule.propertyValue("always"));
    }
}

