/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javabuildplugin;

import java.util.Optional;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuildplugin.JavaBuildPluginAdditionalElements;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;

public class JavaBuildPlugin {
    private final DependencyId dependencyId;
    private final Optional<VersionSlug> versionSlug;
    private final Optional<JavaBuildPluginAdditionalElements> additionalElements;

    private JavaBuildPlugin(JavaBuildPluginBuilder builder) {
        this.dependencyId = new DependencyId(builder.groupId, builder.artifactId);
        this.versionSlug = Optional.ofNullable(builder.versionSlug);
        this.additionalElements = Optional.ofNullable(builder.additionalElements);
    }

    public static JavaBuildPluginGroupIdBuilder builder() {
        return new JavaBuildPluginBuilder();
    }

    public Optional<VersionSlug> versionSlug() {
        return this.versionSlug;
    }

    public Optional<JavaBuildPluginAdditionalElements> additionalElements() {
        return this.additionalElements;
    }

    public DependencyId dependencyId() {
        return this.dependencyId;
    }

    public static class JavaBuildPluginBuilder
    implements JavaBuildPluginGroupIdBuilder,
    JavaBuildPluginArtifactIdBuilder,
    JavaBuildPluginOptionalBuilder {
        private GroupId groupId;
        private ArtifactId artifactId;
        private VersionSlug versionSlug;
        private JavaBuildPluginAdditionalElements additionalElements;

        private JavaBuildPluginBuilder() {
        }

        @Override
        public JavaBuildPluginArtifactIdBuilder groupId(GroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public JavaBuildPluginOptionalBuilder artifactId(ArtifactId artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Override
        public JavaBuildPluginOptionalBuilder versionSlug(VersionSlug versionSlug) {
            this.versionSlug = versionSlug;
            return this;
        }

        @Override
        public JavaBuildPluginOptionalBuilder additionalElements(JavaBuildPluginAdditionalElements additionalElements) {
            this.additionalElements = additionalElements;
            return this;
        }

        @Override
        public JavaBuildPlugin build() {
            return new JavaBuildPlugin(this);
        }
    }

    public static interface JavaBuildPluginOptionalBuilder {
        public JavaBuildPluginOptionalBuilder versionSlug(VersionSlug var1);

        public JavaBuildPluginOptionalBuilder additionalElements(JavaBuildPluginAdditionalElements var1);

        public JavaBuildPlugin build();

        default public JavaBuildPluginOptionalBuilder versionSlug(String slug) {
            return this.versionSlug(new VersionSlug(slug));
        }

        default public JavaBuildPluginOptionalBuilder additionalElements(String additionalElements) {
            return this.additionalElements(new JavaBuildPluginAdditionalElements(additionalElements));
        }
    }

    public static interface JavaBuildPluginArtifactIdBuilder {
        public JavaBuildPluginOptionalBuilder artifactId(ArtifactId var1);

        default public JavaBuildPluginOptionalBuilder artifactId(String artifactId) {
            return this.artifactId(new ArtifactId(artifactId));
        }
    }

    public static interface JavaBuildPluginGroupIdBuilder {
        public JavaBuildPluginArtifactIdBuilder groupId(GroupId var1);

        default public JavaBuildPluginArtifactIdBuilder groupId(String groupId) {
            return this.groupId(new GroupId(groupId));
        }
    }
}

