/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterFeatureSlug;
import tech.jhipster.lite.module.domain.landscape.JHipsterFeatureDependency;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscapeDependency;
import tech.jhipster.lite.module.domain.landscape.JHipsterModuleDependency;
import tech.jhipster.lite.module.domain.resource.JHipsterFeatureSlugFactory;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleSlugFactory;

public class JHipsterModuleOrganization {
    public static final JHipsterModuleOrganization STANDALONE = JHipsterModuleOrganization.builder().build();
    public static final JHipsterModuleOrganization SPRINGBOOT_DEPENDENCY = JHipsterModuleOrganization.builder().addModuleDependency("spring-boot").build();
    private final Optional<JHipsterFeatureSlug> feature;
    private final Collection<JHipsterLandscapeDependency> dependencies;

    private JHipsterModuleOrganization(JHipsterModuleOrganizationBuilder builder) {
        this.feature = builder.feature;
        this.dependencies = builder.dependencies;
    }

    public static JHipsterModuleOrganizationBuilder builder() {
        return new JHipsterModuleOrganizationBuilder();
    }

    public Optional<JHipsterFeatureSlug> feature() {
        return this.feature;
    }

    public Collection<JHipsterLandscapeDependency> dependencies() {
        return this.dependencies;
    }

    public static class JHipsterModuleOrganizationBuilder {
        private final Collection<JHipsterLandscapeDependency> dependencies = new ArrayList<JHipsterLandscapeDependency>();
        private Optional<JHipsterFeatureSlug> feature = Optional.empty();

        @Deprecated(forRemoval=true)
        public JHipsterModuleOrganizationBuilder feature(String feature) {
            return this.feature(() -> feature);
        }

        public JHipsterModuleOrganizationBuilder feature(JHipsterFeatureSlugFactory feature) {
            Assert.notNull("feature", feature);
            this.feature = feature.build();
            return this;
        }

        @Deprecated(forRemoval=true)
        public JHipsterModuleOrganizationBuilder addModuleDependency(String module) {
            return this.addDependency(() -> module);
        }

        public JHipsterModuleOrganizationBuilder addDependency(JHipsterModuleSlugFactory module) {
            Assert.notNull("module", module);
            this.dependencies.add(new JHipsterModuleDependency(module.build()));
            return this;
        }

        @Deprecated(forRemoval=true)
        public JHipsterModuleOrganizationBuilder addFeatureDependency(String feature) {
            return this.addDependency(() -> feature);
        }

        public JHipsterModuleOrganizationBuilder addDependency(JHipsterFeatureSlugFactory feature) {
            Assert.notNull("feature", feature);
            feature.build().map(JHipsterFeatureDependency::new).ifPresent(this.dependencies::add);
            return this;
        }

        public JHipsterModuleOrganization build() {
            return new JHipsterModuleOrganization(this);
        }
    }
}

