/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleTag;

public class JHipsterModuleTags {
    private static final Comparator<JHipsterModuleTag> TAG_COMPARATOR = Comparator.comparing(JHipsterModuleTag::get);
    private final Collection<JHipsterModuleTag> tags;

    private JHipsterModuleTags(JHipsterModuleTagsBuilder builder) {
        this.tags = Collections.unmodifiableCollection(builder.tags.stream().sorted(TAG_COMPARATOR).toList());
    }

    public static JHipsterModuleTagsBuilder builder() {
        return new JHipsterModuleTagsBuilder();
    }

    public Collection<JHipsterModuleTag> get() {
        return this.tags;
    }

    public boolean contains(JHipsterModuleTag other) {
        Assert.notNull("other", other);
        return this.tags.contains(other);
    }

    public static class JHipsterModuleTagsBuilder {
        private final Collection<JHipsterModuleTag> tags = new ArrayList<JHipsterModuleTag>();

        public JHipsterModuleTagsBuilder add(String ... tags) {
            this.add(List.of(tags));
            return this;
        }

        private JHipsterModuleTagsBuilder add(Collection<String> tags) {
            Assert.field("tags", tags).noNullElement();
            this.tags.addAll(tags.stream().map(JHipsterModuleTag::new).toList());
            return this;
        }

        public JHipsterModuleTags build() {
            return new JHipsterModuleTags(this);
        }
    }
}

