/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.stereotype.Service;
import tech.jhipster.lite.common.domain.Generated;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.javaproperties.SpringProperties;
import tech.jhipster.lite.module.domain.javaproperties.SpringProperty;
import tech.jhipster.lite.module.domain.javaproperties.SpringPropertyType;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.PropertiesFileSpringPropertiesHandler;

@Service
class FileSystemSpringPropertiesCommandsHandler {
    private static final String DEFAULT_MAIN_FOLDER = "src/main/resources/config/";
    private static final String DEFAULT_TEST_FOLDER = "src/test/resources/config/";
    private static final Map<SpringPropertyType, List<String>> PROPERTIES_PATHS = FileSystemSpringPropertiesCommandsHandler.buildPaths();

    FileSystemSpringPropertiesCommandsHandler() {
    }

    private static Map<SpringPropertyType, List<String>> buildPaths() {
        return Map.of(SpringPropertyType.MAIN_PROPERTIES, List.of(DEFAULT_MAIN_FOLDER, "src/main/resources/"), SpringPropertyType.MAIN_BOOTSTRAP_PROPERTIES, List.of(DEFAULT_MAIN_FOLDER, "src/main/resources/"), SpringPropertyType.TEST_PROPERTIES, List.of(DEFAULT_TEST_FOLDER, "src/test/resources/"), SpringPropertyType.TEST_BOOTSTRAP_PROPERTIES, List.of(DEFAULT_TEST_FOLDER, "src/test/resources/"));
    }

    public void handle(JHipsterProjectFolder projectFolder, SpringProperties properties) {
        Assert.notNull("projectFolder", projectFolder);
        Assert.notNull("properties", properties);
        properties.get().forEach(this.setProperty(projectFolder));
    }

    private Consumer<SpringProperty> setProperty(JHipsterProjectFolder projectFolder) {
        return property -> new PropertiesFileSpringPropertiesHandler(FileSystemSpringPropertiesCommandsHandler.getPath(projectFolder, property)).set(property.key(), property.value());
    }

    private static Path getPath(JHipsterProjectFolder projectFolder, SpringProperty property) {
        return PROPERTIES_PATHS.get((Object)property.type()).stream().map(FileSystemSpringPropertiesCommandsHandler.toFilePath(projectFolder, property)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElseGet(FileSystemSpringPropertiesCommandsHandler.defaultPropertiesFile(projectFolder, property));
    }

    private static Function<String, Path> toFilePath(JHipsterProjectFolder projectFolder, SpringProperty property) {
        return folder -> projectFolder.filePath(folder + FileSystemSpringPropertiesCommandsHandler.propertiesFilename(property));
    }

    @Generated(reason="Jacoco thinks there is a missed branch")
    private static Supplier<Path> defaultPropertiesFile(JHipsterProjectFolder projectFolder, SpringProperty property) {
        return switch (property.type()) {
            default -> throw new IncompatibleClassChangeError();
            case SpringPropertyType.MAIN_PROPERTIES -> () -> projectFolder.filePath(DEFAULT_MAIN_FOLDER + FileSystemSpringPropertiesCommandsHandler.propertiesFilename(property));
            case SpringPropertyType.MAIN_BOOTSTRAP_PROPERTIES -> () -> projectFolder.filePath(DEFAULT_MAIN_FOLDER + FileSystemSpringPropertiesCommandsHandler.propertiesFilename(property));
            case SpringPropertyType.TEST_PROPERTIES -> () -> projectFolder.filePath(DEFAULT_TEST_FOLDER + FileSystemSpringPropertiesCommandsHandler.propertiesFilename(property));
            case SpringPropertyType.TEST_BOOTSTRAP_PROPERTIES -> () -> projectFolder.filePath(DEFAULT_TEST_FOLDER + FileSystemSpringPropertiesCommandsHandler.propertiesFilename(property));
        };
    }

    private static String propertiesFilename(SpringProperty property) {
        return property.filename() + ".properties";
    }
}

