/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.javadependency;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.joox.JOOX;
import org.joox.Match;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import tech.jhipster.lite.common.domain.Enums;
import tech.jhipster.lite.common.domain.Generated;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.error.domain.GeneratorException;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuild.command.AddBuildPluginManagement;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectJavaBuildPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaBuildPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.AddJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveJavaDependencyManagement;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.javabuildplugin.JavaBuildPluginAdditionalElements;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyClassifier;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.InvalidPomException;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.MalformedAdditionalInformationException;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.MavenScope;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.MavenType;

class MavenCommandHandler {
    private static final String FORMATTED_LINE_END = "> *\n";
    private static final String RESULTING_LINE_END = ">\n";
    private static final Pattern SPACES_ONLY_LINE = Pattern.compile("^\\s+$", 8);
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    private static final String COMMAND = "command";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String CLASSIFIER = "classifier";
    private static final String PARENT = "parent";
    private static final String PACKAGING = "packaging";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String PROPERTIES = "properties";
    private static final String DEPENDENCY_MANAGEMENT = "dependencyManagement";
    private static final String DEPENDENCIES = "dependencies";
    private static final String PLUGINS = "plugins";
    private static final String[] PROPERTIES_ANCHORS = new String[]{"parent", "packaging", "description", "name", "version", "artifactId"};
    private static final String[] DEPENDENCIES_ANCHORS = new String[]{"dependencyManagement", "properties", "parent", "packaging", "description", "name", "version", "artifactId"};
    private static final String[] BUILD_ANCHORS = new String[]{"dependencies", "dependencyManagement", "properties", "parent", "packaging", "description", "name", "version", "artifactId"};
    private final Indentation indentation;
    private final Path pomPath;
    private final Match document;

    MavenCommandHandler(Indentation indentation, Path pomPath) {
        Assert.notNull("indentation", indentation);
        Assert.notNull("pomPath", pomPath);
        this.indentation = indentation;
        this.pomPath = pomPath;
        this.document = this.readDocument(pomPath);
    }

    private Match readDocument(Path pomPath) {
        Match match;
        block8: {
            InputStream input = Files.newInputStream(pomPath, new OpenOption[0]);
            try {
                match = JOOX.$((InputStream)input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    throw new GeneratorException("Error reading pom content: " + e.getMessage(), e);
                }
            }
            input.close();
        }
        return match;
    }

    public void handle(SetVersion command) {
        Assert.notNull(COMMAND, command);
        Match properties = this.document.find("project > properties");
        if (properties.isEmpty()) {
            this.appendProperties(command);
        } else {
            this.appendPropertyLine(properties, command);
        }
        this.writePom();
    }

    private void appendProperties(SetVersion command) {
        Match properties = JOOX.$((String)PROPERTIES).append("\n").append(this.indentation.spaces());
        this.appendPropertyLine(properties, command);
        this.findFirst(PROPERTIES_ANCHORS).after(new Match[]{properties});
        this.document.find("project > properties").before("\n").before("\n").before(this.indentation.spaces());
    }

    private void appendPropertyLine(Match properties, SetVersion command) {
        Match propertyNode = properties.children().filter(command.property());
        if (propertyNode.isNotEmpty()) {
            propertyNode.text(command.dependencyVersion());
        } else {
            properties.append(this.indentation.spaces()).append(new Match[]{JOOX.$((String)command.property(), (String)command.dependencyVersion())}).append("\n").append(this.indentation.spaces());
        }
    }

    public void handle(RemoveJavaDependencyManagement command) {
        Assert.notNull(COMMAND, command);
        this.removeDependency("project > dependencyManagement > dependencies > dependency", command.dependency());
    }

    public void handle(RemoveDirectJavaDependency command) {
        Assert.notNull(COMMAND, command);
        this.removeDependency("project > dependencies > dependency", command.dependency());
    }

    private void removeDependency(String rootPath, DependencyId dependency) {
        this.document.find(rootPath).each().stream().filter(this.dependencyMatch(dependency)).forEach(Match::remove);
        this.writePom();
    }

    public void handle(AddJavaDependencyManagement command) {
        Assert.notNull(COMMAND, command);
        Match dependencies = this.document.find("project > dependencyManagement > dependencies");
        if (dependencies.isEmpty()) {
            this.appendDependenciesManagement(command);
        } else {
            this.appendDependencyManagement(command, dependencies);
        }
        this.writePom();
    }

    private void appendDependenciesManagement(AddJavaDependencyManagement command) {
        Match dependencies = JOOX.$((String)DEPENDENCY_MANAGEMENT).append("\n").append(this.indentation.times(2)).append(new Match[]{JOOX.$((String)DEPENDENCIES).append("\n").append(this.indentation.times(3)).append(new Match[]{this.dependencyNode(command, 3)}).append("\n").append(this.indentation.times(2))}).append("\n").append(this.indentation.spaces());
        this.findFirst(DEPENDENCIES_ANCHORS).after(new Match[]{dependencies});
        this.document.find("project > dependencyManagement").before("\n").before("\n").before(this.indentation.spaces());
    }

    private void appendDependencyManagement(AddJavaDependency command, Match dependencies) {
        this.appendNotTestDependency(command, dependencies, 3);
    }

    public void handle(AddDirectJavaDependency command) {
        Assert.notNull(COMMAND, command);
        Match dependencies = this.document.find("project > dependencies");
        if (dependencies.isEmpty()) {
            this.appendDependencies(command);
        } else {
            this.appendDependency(command, dependencies);
        }
        this.writePom();
    }

    private void appendDependencies(AddDirectJavaDependency command) {
        Match dependencies = JOOX.$((String)DEPENDENCIES).append("\n").append(this.indentation.times(2)).append(new Match[]{this.dependencyNode(command, 2)}).append("\n").append(this.indentation.spaces());
        this.findFirst(DEPENDENCIES_ANCHORS).after(new Match[]{dependencies});
        this.document.find("project > dependencies").before("\n").before("\n").before(this.indentation.spaces());
    }

    private void appendDependency(AddDirectJavaDependency command, Match dependencies) {
        if (command.scope() == JavaDependencyScope.TEST) {
            this.appendDependencyInLastPosition(command, dependencies, 2);
        } else {
            this.appendNotTestDependency(command, dependencies, 2);
        }
    }

    private void appendNotTestDependency(AddJavaDependency command, Match dependencies, int level) {
        dependencies.children().each().stream().filter(this.testDependency()).findFirst().ifPresentOrElse(this.appendBeforeFirstTestDependency(command, level), () -> this.appendDependencyInLastPosition(command, dependencies, level));
    }

    private Consumer<Match> appendBeforeFirstTestDependency(AddJavaDependency command, int level) {
        return firstTestDependency -> {
            Match dependencyNode = this.dependencyNode(command, level);
            firstTestDependency.before(new Match[]{dependencyNode});
            this.document.find("project > dependencies > dependency").each().stream().filter(this.dependencyMatch(command.dependencyId())).findFirst().ifPresent(node -> node.after(this.indentation.times(level)).after("\n").after("\n"));
        };
    }

    private Predicate<Match> dependencyMatch(DependencyId dependency) {
        return dependencyNode -> {
            boolean sameGroupId = dependencyNode.child(GROUP_ID).text().equals(dependency.groupId().get());
            boolean sameArtifactId = dependencyNode.child(ARTIFACT_ID).text().equals(dependency.artifactId().get());
            return sameGroupId && sameArtifactId;
        };
    }

    private Predicate<Match> testDependency() {
        return dependency -> "test".equals(dependency.child("scope").text());
    }

    private void appendDependencyInLastPosition(AddJavaDependency command, Match dependencies, int level) {
        dependencies.append("\n").append(this.indentation.times(level)).append(new Match[]{this.dependencyNode(command, level)}).append("\n").append(this.indentation.times(level - 1));
    }

    private Match dependencyNode(AddJavaDependency command, int level) {
        Match dependency = this.buildDependencyNode(command, level);
        this.appendVersion(command.version(), dependency, level);
        this.appendClassifier(command.classifier(), dependency, level);
        this.appendScope(command, dependency, level);
        this.appendOptional(command, dependency, level);
        this.appendType(command, dependency, level);
        this.appendExclusions(command, dependency, level);
        dependency.append("\n").append(this.indentation.times(level));
        return dependency;
    }

    private Match buildDependencyNode(AddJavaDependency command, int level) {
        return this.appendDependencyId(JOOX.$((String)"dependency"), command.dependencyId(), level);
    }

    private void appendScope(AddJavaDependency command, Match dependency, int level) {
        if (command.scope() != JavaDependencyScope.COMPILE) {
            dependency.append("\n").append(this.indentation.times(level + 1)).append(new Match[]{JOOX.$((String)"scope", (String)Enums.map(command.scope(), MavenScope.class).key())});
        }
    }

    private void appendOptional(AddJavaDependency command, Match dependency, int level) {
        if (command.optional()) {
            dependency.append("\n").append(this.indentation.times(level + 1)).append(new Match[]{JOOX.$((String)"optional", (String)"true")});
        }
    }

    private void appendType(AddJavaDependency command, Match dependency, int level) {
        command.dependencyType().ifPresent(type -> dependency.append("\n").append(this.indentation.times(level + 1)).append(new Match[]{JOOX.$((String)"type", (String)Enums.map(type, MavenType.class).key())}));
    }

    private void appendExclusions(AddJavaDependency command, Match dependency, int level) {
        Collection<DependencyId> exclusions = command.exclusions();
        if (exclusions.isEmpty()) {
            return;
        }
        dependency.append("\n").append(this.indentation.times(level + 1)).append(new Match[]{this.buildExclusionsNode(level, exclusions)});
    }

    private Match buildExclusionsNode(int level, Collection<DependencyId> exclusions) {
        Match exclusionsNode = JOOX.$((String)"exclusions");
        exclusions.stream().map(this.toExclusionNode(level)).forEach(this.appendExclusionNode(level, exclusionsNode));
        exclusionsNode.append("\n").append(this.indentation.times(level + 1));
        return exclusionsNode;
    }

    private Function<DependencyId, Match> toExclusionNode(int level) {
        return exculsion -> this.appendDependencyId(JOOX.$((String)"exclusion"), (DependencyId)exculsion, level + 2).append("\n").append(this.indentation.times(level + 2));
    }

    private Consumer<Match> appendExclusionNode(int level, Match exclusionsNode) {
        return exclusionNode -> exclusionsNode.append("\n").append(this.indentation.times(level + 2)).append(new Match[]{exclusionNode});
    }

    public void handle(AddBuildPluginManagement command) {
        Assert.notNull(COMMAND, command);
        Match pluginNode = this.pluginNode(command, 4);
        Match buildNode = this.findBuildNode();
        if (buildNode.isEmpty()) {
            this.appendBuildNode(this.pluginManagementNode(pluginNode));
        } else {
            this.appendPluginMangementInBuildNode(pluginNode, buildNode);
        }
        this.writePom();
    }

    private void appendPluginMangementInBuildNode(Match pluginNode, Match buildNode) {
        Match pluginManagementNode = buildNode.child("pluginManagement");
        if (pluginManagementNode.isEmpty()) {
            this.appendPluginManagement(pluginNode, buildNode);
        } else {
            this.appendInPluginManagement(pluginNode, pluginManagementNode);
        }
    }

    private Match appendPluginManagement(Match pluginNode, Match buildNode) {
        return buildNode.append(this.indentation.times(1)).append(new Match[]{this.pluginManagementNode(pluginNode)}).append("\n").append(this.indentation.times(1));
    }

    private void appendInPluginManagement(Match pluginNode, Match pluginManagementNode) {
        Match pluginsNode = pluginManagementNode.child(PLUGINS);
        if (pluginsNode.isEmpty()) {
            this.appendPluginsNode(pluginManagementNode, pluginNode, 4);
        } else {
            this.appendPluginNode(pluginsNode, pluginNode, 4);
        }
    }

    private Match pluginManagementNode(Match pluginNode) {
        return JOOX.$((String)"pluginManagement").append("\n").append(this.indentation.times(3)).append(new Match[]{this.pluginsNode(pluginNode, 4)}).append("\n").append(this.indentation.times(2));
    }

    public void handle(AddDirectJavaBuildPlugin command) {
        Assert.notNull(COMMAND, command);
        Match pluginNode = this.pluginNode(command, 3);
        Match buildNode = this.findBuildNode();
        if (buildNode.isEmpty()) {
            this.appendBuildNode(this.pluginsNode(pluginNode, 3));
        } else {
            this.appendPluginInBuildNode(pluginNode, buildNode);
        }
        this.writePom();
    }

    private void appendPluginInBuildNode(Match pluginNode, Match buildNode) {
        Match pluginsNode = buildNode.child(PLUGINS);
        if (pluginsNode.isEmpty()) {
            this.appendPluginsNode(buildNode, pluginNode, 3);
        } else {
            this.appendPluginNode(pluginsNode, pluginNode, 3);
        }
    }

    private Match appendPluginsNode(Match parent, Match pluginNode, int level) {
        return parent.append(this.indentation.times(1)).append(new Match[]{this.pluginsNode(pluginNode, level)}).append("\n").append(this.indentation.times(level - 2));
    }

    private Match pluginsNode(Match pluginNode, int level) {
        return JOOX.$((String)PLUGINS).append("\n").append(this.indentation.times(level)).append(new Match[]{pluginNode.append(this.indentation.times(level))}).append("\n").append(this.indentation.times(level - 1));
    }

    private void appendBuildNode(Match innerNode) {
        Match build = JOOX.$((String)"build").append("\n").append(this.indentation.times(2)).append(new Match[]{innerNode}).append("\n").append(this.indentation.times(1));
        this.findFirst(BUILD_ANCHORS).after(new Match[]{build});
        this.findBuildNode().before("\n").before("\n").before(this.indentation.spaces());
    }

    private Match findBuildNode() {
        return this.document.find("project > build");
    }

    private Match appendPluginNode(Match pluginsNode, Match pluginNode, int level) {
        return pluginsNode.append(this.indentation.times(1)).append(new Match[]{pluginNode.append(this.indentation.times(level))}).append("\n").append(this.indentation.times(level - 1));
    }

    private Match pluginNode(AddJavaBuildPlugin command, int level) {
        Match pluginNode = this.appendDependencyId(JOOX.$((String)"plugin"), command.dependencyId(), level);
        this.appendVersion(command.versionSlug(), pluginNode, level);
        command.additionalElements().ifPresent(this.appendAdditionalElements(pluginNode, level));
        return pluginNode.append("\n");
    }

    private Match appendDependencyId(Match node, DependencyId dependency, int level) {
        return node.append("\n").append(this.indentation.times(level + 1)).append(new Match[]{JOOX.$((String)GROUP_ID, (String)dependency.groupId().get())}).append("\n").append(this.indentation.times(level + 1)).append(new Match[]{JOOX.$((String)ARTIFACT_ID, (String)dependency.artifactId().get())});
    }

    private void appendVersion(Optional<VersionSlug> versionSlug, Match node, int level) {
        versionSlug.ifPresent(version -> node.append("\n").append(this.indentation.times(level + 1)).append(new Match[]{JOOX.$((String)VERSION, (String)version.mavenVariable())}));
    }

    private void appendClassifier(Optional<JavaDependencyClassifier> classifier, Match node, int level) {
        classifier.ifPresent(depClassifier -> node.append("\n").append(this.indentation.times(level + 1)).append(new Match[]{JOOX.$((String)CLASSIFIER, (String)depClassifier.get())}));
    }

    private Consumer<JavaBuildPluginAdditionalElements> appendAdditionalElements(Match pluginNode, int level) {
        return additionalElements -> pluginNode.append("\n").append(this.indentation.times(level + 1)).append(this.formatAdditionalElements((JavaBuildPluginAdditionalElements)additionalElements, level + 1));
    }

    private String formatAdditionalElements(JavaBuildPluginAdditionalElements additionalElements, int level) {
        String string;
        StringWriter stringWriter = new StringWriter();
        try {
            Document additionalElementsDocument = DocumentHelper.parseText((String)("<root>" + additionalElements.get() + "</root>"));
            XMLWriter writer = new XMLWriter((Writer)stringWriter, this.buildFormat());
            writer.write(additionalElementsDocument);
            String result = stringWriter.toString();
            string = result.substring(10, result.length() - 10).replaceAll(FORMATTED_LINE_END, RESULTING_LINE_END).indent((level - 1) * this.indentation.spacesCount());
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | DocumentException e) {
                throw new MalformedAdditionalInformationException(e);
            }
        }
        stringWriter.close();
        return string;
    }

    private OutputFormat buildFormat() {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndentSize(this.indentation.spacesCount());
        format.setSuppressDeclaration(true);
        format.setEncoding("UTF-8");
        return format;
    }

    @Generated(reason="The exception hanlding is hard to test and an implementation detail")
    private void writePom() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.pomPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(HEADER);
            for (Element e : this.document) {
                String element = JOOX.$((Element)e).toString().replace("\r\n", "\n").replace(" xmlns=\"\"", "");
                element = SPACES_ONLY_LINE.matcher(element).replaceAll("");
                writer.write(element);
            }
        }
        catch (IOException e) {
            throw new GeneratorException("Error writing pom: " + e.getMessage(), e);
        }
    }

    private Match findFirst(String ... elements) {
        return Stream.of(elements).map(element -> "project > " + element).map(arg_0 -> ((Match)this.document).find(arg_0)).filter(Match::isNotEmpty).findFirst().orElseThrow(InvalidPomException::new);
    }
}

