/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.angular.security.oauth2.domain;

import java.util.regex.Pattern;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.packagejson.VersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacements;
import tech.jhipster.lite.module.domain.replacement.RegexReplacer;

public class AngularOauth2ModuleFactory {
    private static final Pattern PROVIDERS_PATTERN = Pattern.compile("(providers: *\\[)");
    private static final ElementReplacer EXISTING_PROVIDERS_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> PROVIDERS_PATTERN.matcher(contentBeforeReplacement).find(), PROVIDERS_PATTERN);
    private static final ElementReplacer ENVIRONMENT_NEEDLE = JHipsterModule.lineAfterRegex("export const environment *= *\\{");
    private static final String KEYCLOAK_ENVIRONMENT = "keycloak: {\n  url: 'http://localhost:9080',\n  realm: 'jhipster',\n  client_id: 'web_app'\n},\n";
    private static final Pattern EMPTY_ALLOWED_COMMON_DEPENDENCIES_PATTERN = Pattern.compile("(\"allowedCommonJsDependencies\": *\\[\\s*)\\]");
    private static final ElementReplacer EMPTY_ALLOWED_COMMON_DEPENDENCIES_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> EMPTY_ALLOWED_COMMON_DEPENDENCIES_PATTERN.matcher(contentBeforeReplacement).find(), EMPTY_ALLOWED_COMMON_DEPENDENCIES_PATTERN);
    private static final Pattern FILLED_ALLOWED_COMMON_DEPENDENCIES_PATTERN = Pattern.compile("(\"allowedCommonJsDependencies\": *\\[[^]]+)\\]");
    private static final ElementReplacer FILLED_ALLOWED_COMMON_DEPENDENCIES_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> FILLED_ALLOWED_COMMON_DEPENDENCIES_PATTERN.matcher(contentBeforeReplacement).find(), FILLED_ALLOWED_COMMON_DEPENDENCIES_PATTERN);
    private static final Pattern FILLED_STANDALONE_PATTERN = Pattern.compile("(imports: *\\[[^]]+)\\]");
    private static final ElementReplacer FILLED_STANDALONE_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> FILLED_STANDALONE_PATTERN.matcher(contentBeforeReplacement).find(), FILLED_STANDALONE_PATTERN);
    private static final ElementReplacer MENU_NEEDLE = JHipsterModule.lineAfterRegex("<span.+id=\\\"menu-space-separator\\\".*></span>");
    private static final String TEST_IMPORTS = "import { By } from '@angular/platform-browser';\nimport LoginComponent from './login/login.component';\n";
    private static final ElementReplacer TEST_NEEDLE = JHipsterModule.lineAfterRegex("^\\s+it\\('should have appName',[^}]+\\}\\);");
    private static final String LOGIN_IMPORT = "import LoginComponent from './login/login.component';\n";
    private static final String LOGIN_COMPONENT_TEST = "\nit('should display login component', () => {\n  fixture.detectChanges();\n\n  expect(fixture.debugElement.query(By.directive(LoginComponent))).toBeTruthy();\n});\n";
    private static final String HTTP_AUTH_INTERCEPTOR_IMPORT = "import { HttpAuthInterceptor } from './app/auth/http-auth.interceptor';\n";
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/angular/security/oauth2/src/main/webapp/app");
    private static final JHipsterDestination APP_DESTINATION = JHipsterModule.to("src/main/webapp/app");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        Indentation indentation = properties.indentation();
        return ((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder)((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)JHipsterModule.moduleBuilder(properties).packageJson().addDependency(JHipsterModule.packageName("keycloak-js"), VersionSource.ANGULAR).and().files().batch(SOURCE.append("auth"), APP_DESTINATION.append("auth")).addFile("oauth2-auth.service.ts").addFile("oauth2-auth.service.spec.ts").addFile("http-auth.interceptor.ts").addFile("http-auth.interceptor.spec.ts").and().batch(SOURCE.append("login"), APP_DESTINATION.append("login")).addFile("login.component.html").addFile("login.component.ts").addFile("login.component.spec.ts").and().and().mandatoryReplacements().in(JHipsterModule.path("src/main/webapp/environments/environment.ts")).add(ENVIRONMENT_NEEDLE, this.keycloakEnvironment(indentation))).and()).in(JHipsterModule.path("src/main/webapp/environments/environment.prod.ts")).add(ENVIRONMENT_NEEDLE, this.keycloakEnvironment(indentation))).and()).in(JHipsterModule.path("angular.json")).add(FILLED_ALLOWED_COMMON_DEPENDENCIES_NEEDLE, "$1, \"keycloak-js\"]")).add(EMPTY_ALLOWED_COMMON_DEPENDENCIES_NEEDLE, "$1\"keycloak-js\"]")).and()).in(JHipsterModule.path("src/main/webapp/main.ts")).add(EXISTING_PROVIDERS_NEEDLE, "providers: [{ provide: HTTP_INTERCEPTORS, useClass: HttpAuthInterceptor, multi: true },")).add(EXISTING_PROVIDERS_NEEDLE, "providers: [ provideHttpClient(withInterceptorsFromDi()),")).add(JHipsterModule.fileStart(), HTTP_AUTH_INTERCEPTOR_IMPORT)).and()).in(JHipsterModule.path("src/main/webapp/app/app.component.ts")).add(FILLED_STANDALONE_NEEDLE, "$1, LoginComponent]")).add(JHipsterModule.fileStart(), LOGIN_IMPORT)).and()).in(JHipsterModule.path("src/main/webapp/app/app.component.spec.ts")).add(JHipsterModule.fileStart(), TEST_IMPORTS)).add(TEST_NEEDLE, LOGIN_COMPONENT_TEST.indent(indentation.spacesCount() * 2))).and()).in(JHipsterModule.path("src/main/webapp/app/app.component.html")).add(MENU_NEEDLE, indentation.spaces() + "<jhi-login></jhi-login>")).and()).and().build();
    }

    private String keycloakEnvironment(Indentation indentation) {
        return KEYCLOAK_ENVIRONMENT.indent(indentation.spacesCount());
    }
}

