/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.javatool.frontendmaven.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuildplugin.JavaBuildPlugin;
import tech.jhipster.lite.module.domain.npm.NpmVersionSource;
import tech.jhipster.lite.module.domain.npm.NpmVersions;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class FrontendMavenModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/frontend");
    private static final String REDIRECTION_PRIMARY = "technical/infrastructure/primary/redirection";
    private final NpmVersions npmVersions;

    public FrontendMavenModuleFactory(NpmVersions npmVersions) {
        this.npmVersions = npmVersions;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).javaDependencies().setVersion(JHipsterModule.javaDependencyVersion("node", "v" + this.npmVersions.get("node", NpmVersionSource.COMMON).get())).setVersion(JHipsterModule.javaDependencyVersion("npm", this.npmVersions.get("npm", NpmVersionSource.COMMON).get())).and().javaBuildPlugins().plugin(this.checksumPlugin()).plugin(this.antrunPlugin()).plugin(this.frontendMavenPlugin()).and().files().add(SOURCE.template("RedirectionResource.java"), JHipsterModule.toSrcMainJava().append(packagePath).append(REDIRECTION_PRIMARY).append("RedirectionResource.java")).and().build();
    }

    private JavaBuildPlugin checksumPlugin() {
        return JHipsterModule.javaBuildPlugin().groupId("net.nicoulaj.maven.plugins").artifactId("checksum-maven-plugin").versionSlug("checksum-maven-plugin").additionalElements("<executions>\n  <execution>\n    <id>create-pre-compiled-webapp-checksum</id>\n    <phase>generate-resources</phase>\n    <goals>\n      <goal>files</goal>\n    </goals>\n  </execution>\n  <execution>\n    <id>create-compiled-webapp-checksum</id>\n    <goals>\n      <goal>files</goal>\n    </goals>\n    <phase>compile</phase>\n    <configuration>\n      <csvSummaryFile>checksums.csv.old</csvSummaryFile>\n    </configuration>\n  </execution>\n</executions>\n<configuration>\n  <fileSets>\n    <fileSet>\n      <directory>${project.basedir}</directory>\n      <includes>\n        <include>src/main/webapp/**/*.*</include>\n        <include>target/classes/static/**/*.*</include>\n        <include>package-lock.json</include>\n        <include>package.json</include>\n        <include>tsconfig.json</include>\n      </includes>\n    </fileSet>\n  </fileSets>\n  <failOnError>false</failOnError>\n  <failIfNoFiles>false</failIfNoFiles>\n  <individualFiles>false</individualFiles>\n  <algorithms>\n    <algorithm>SHA-1</algorithm>\n  </algorithms>\n  <includeRelativePath>true</includeRelativePath>\n  <quiet>true</quiet>\n</configuration>\n").build();
    }

    private JavaBuildPlugin antrunPlugin() {
        return JHipsterModule.javaBuildPlugin().groupId("org.apache.maven.plugins").artifactId("maven-antrun-plugin").versionSlug("maven-antrun-plugin").additionalElements("<executions>\n  <execution>\n    <id>eval-frontend-checksum</id>\n    <phase>generate-resources</phase>\n    <goals>\n      <goal>run</goal>\n    </goals>\n    <configuration>\n      <target>\n        <condition property=\"skip.npm\" value=\"true\" else=\"false\">\n          <and>\n            <available file=\"checksums.csv\" filepath=\"${project.build.directory}\" />\n            <available file=\"checksums.csv.old\" filepath=\"${project.build.directory}\" />\n            <filesmatch file1=\"${project.build.directory}/checksums.csv\" file2=\"${project.build.directory}/checksums.csv.old\" />\n          </and>\n        </condition>\n      </target>\n      <exportAntProperties>true</exportAntProperties>\n    </configuration>\n  </execution>\n</executions>\n").build();
    }

    private JavaBuildPlugin frontendMavenPlugin() {
        return JHipsterModule.javaBuildPlugin().groupId("com.github.eirslett").artifactId("frontend-maven-plugin").versionSlug("frontend-maven-plugin").additionalElements("<executions>\n  <execution>\n    <id>install-node-and-npm</id>\n    <goals>\n      <goal>install-node-and-npm</goal>\n    </goals>\n    <configuration>\n      <nodeVersion>${node.version}</nodeVersion>\n      <npmVersion>${npm.version}</npmVersion>\n    </configuration>\n  </execution>\n  <execution>\n    <id>npm install</id>\n    <goals>\n      <goal>npm</goal>\n    </goals>\n  </execution>\n  <execution>\n    <id>build front</id>\n    <goals>\n      <goal>npm</goal>\n    </goals>\n    <phase>generate-resources</phase>\n    <configuration>\n      <arguments>run build</arguments>\n      <environmentVariables>\n        <APP_VERSION>${project.version}</APP_VERSION>\n      </environmentVariables>\n      <npmInheritsProxyConfigFromMaven>false</npmInheritsProxyConfigFromMaven>\n    </configuration>\n  </execution>\n  <execution>\n    <id>front test</id>\n    <goals>\n      <goal>npm</goal>\n    </goals>\n    <phase>test</phase>\n    <configuration>\n      <arguments>run test</arguments>\n      <npmInheritsProxyConfigFromMaven>false</npmInheritsProxyConfigFromMaven>\n    </configuration>\n  </execution>\n</executions>\n").build();
    }
}

