/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.springcloud.gateway.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.generator.server.springboot.springcloud.common.domain.SpringCloudModuleDependencies;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class GatewayModuleFactory {
    private static final String GATEWAY_PACKAGE = "technical/infrastructure/primary/rest";
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/springcloud/gateway/java");
    private static final PropertyValue TRUE_VALUE = JHipsterModule.propertyValue("true");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        JHipsterDestination testDestination = JHipsterModule.toSrcTestJava().append(packagePath).append(GATEWAY_PACKAGE);
        JHipsterDestination destination = JHipsterModule.toSrcMainJava().append(packagePath).append(GATEWAY_PACKAGE);
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependencyManagement(SpringCloudModuleDependencies.springCloudDependenciesManagement()).addDependency(SpringCloudModuleDependencies.SPRING_CLOUD_GROUP, JHipsterModule.artifactId("spring-cloud-starter-bootstrap")).addDependency(SpringCloudModuleDependencies.SPRING_CLOUD_GROUP, JHipsterModule.artifactId("spring-cloud-starter-gateway")).and().springMainBootstrapProperties().set(JHipsterModule.propertyKey("spring.application.name"), JHipsterModule.propertyValue(properties.projectBaseName().get())).set(JHipsterModule.propertyKey("spring.cloud.gateway.discovery.locator.enabled"), TRUE_VALUE).set(JHipsterModule.propertyKey("spring.cloud.gateway.discovery.locator.lower-case-service-id"), TRUE_VALUE).set(JHipsterModule.propertyKey("spring.cloud.gateway.discovery.locator.predicates[0].name"), JHipsterModule.propertyValue("Path")).set(JHipsterModule.propertyKey("spring.cloud.gateway.discovery.locator.predicates[0].args[pattern]"), JHipsterModule.propertyValue("'/services/'+serviceId.toLowerCase()+'/**'")).set(JHipsterModule.propertyKey("spring.cloud.gateway.discovery.locator.filters[0].name"), JHipsterModule.propertyValue("RewritePath")).set(JHipsterModule.propertyKey("spring.cloud.gateway.discovery.locator.filters[0].args[regexp]"), JHipsterModule.propertyValue("'/services/' + serviceId.toLowerCase() + '/(?<remaining>.*)'")).set(JHipsterModule.propertyKey("spring.cloud.gateway.discovery.locator.filters[0].args[replacement]"), JHipsterModule.propertyValue("'/${remaining}'")).and().springTestBootstrapProperties().set(JHipsterModule.propertyKey("spring.application.name"), JHipsterModule.propertyValue(properties.projectBaseName().get())).set(JHipsterModule.propertyKey("spring.cloud.gateway.discovery.locator.enabled"), JHipsterModule.propertyValue("false")).and().files().add(SOURCE.template("GatewayResource.java"), destination.append("GatewayResource.java")).add(SOURCE.template("RouteVM.java"), destination.append("vm/RouteVM.java")).add(SOURCE.template("test/GatewayResourceIT.java"), testDestination.append("GatewayResourceIT.java")).and().build();
    }
}

