/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.DocumentationTitle;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterModuleContext;
import tech.jhipster.lite.module.domain.JHipsterModulePreActions;
import tech.jhipster.lite.module.domain.JHipsterModuleShortcuts;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.LocalEnvironment;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterFilesToDelete;
import tech.jhipster.lite.module.domain.file.JHipsterFilesToMove;
import tech.jhipster.lite.module.domain.file.JHipsterModuleFile;
import tech.jhipster.lite.module.domain.file.JHipsterModuleFiles;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.file.JHipsterTemplatedFile;
import tech.jhipster.lite.module.domain.file.JHipsterTemplatedFiles;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuildplugin.JHipsterModuleJavaBuildPlugin;
import tech.jhipster.lite.module.domain.javabuildplugin.JavaBuildPlugin;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JHipsterModuleJavaDependencies;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.javaproperties.JHipsterModuleSpringProperties;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javaproperties.SpringProfile;
import tech.jhipster.lite.module.domain.javaproperties.SpringProperties;
import tech.jhipster.lite.module.domain.javaproperties.SpringProperty;
import tech.jhipster.lite.module.domain.javaproperties.SpringPropertyType;
import tech.jhipster.lite.module.domain.packagejson.JHipsterModulePackageJson;
import tech.jhipster.lite.module.domain.packagejson.PackageName;
import tech.jhipster.lite.module.domain.packagejson.ScriptCommand;
import tech.jhipster.lite.module.domain.packagejson.ScriptKey;
import tech.jhipster.lite.module.domain.postaction.JHipsterModulePostActions;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.domain.replacement.FileStartReplacer;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacements;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleOptionalReplacements;
import tech.jhipster.lite.module.domain.replacement.RegexNeedleAfterReplacer;
import tech.jhipster.lite.module.domain.replacement.RegexNeedleBeforeReplacer;
import tech.jhipster.lite.module.domain.replacement.RegexReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.module.domain.replacement.TextNeedleBeforeReplacer;
import tech.jhipster.lite.module.domain.replacement.TextReplacer;

public class JHipsterModule {
    public static final String LINE_BREAK = "\n";
    private final JHipsterModuleProperties properties;
    private final JHipsterModuleFiles files;
    private final JHipsterModuleMandatoryReplacements mandatoryReplacements;
    private final JHipsterModuleOptionalReplacements optionalReplacements;
    private final JHipsterModuleContext context;
    private final JHipsterModuleJavaDependencies javaDependencies;
    private final JHipsterModuleJavaBuildPlugin javaBuildPlugins;
    private final JHipsterModulePackageJson packageJson;
    private final JHipsterModulePreActions preActions;
    private final JHipsterModulePostActions postActions;
    private final SpringProperties springProperties;

    private JHipsterModule(JHipsterModuleBuilder builder) {
        this.properties = builder.properties;
        this.files = builder.files.build();
        this.mandatoryReplacements = builder.mandatoryReplacements.build();
        this.optionalReplacements = builder.optionalReplacements.build();
        this.context = builder.context.build();
        this.javaDependencies = builder.javaDependencies.build();
        this.javaBuildPlugins = builder.javaBuildPlugins.build();
        this.packageJson = builder.packageJson.build();
        this.preActions = builder.preActions.build();
        this.postActions = builder.postActions.build();
        this.springProperties = this.buildSpringProperties(builder);
    }

    private SpringProperties buildSpringProperties(JHipsterModuleBuilder builder) {
        return new SpringProperties(builder.springProperties.entrySet().stream().flatMap(this.toSpringProperties()).toList());
    }

    private Function<Map.Entry<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder>, Stream<SpringProperty>> toSpringProperties() {
        return inputProperties -> ((JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder)inputProperties.getValue()).build().properties().entrySet().stream().map(this.toSpringProperty((Map.Entry<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder>)inputProperties));
    }

    private Function<Map.Entry<PropertyKey, PropertyValue>, SpringProperty> toSpringProperty(Map.Entry<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder> inputProperties) {
        return property -> SpringProperty.builder(((PropertiesKey)inputProperties.getKey()).type()).key((PropertyKey)property.getKey()).value((PropertyValue)property.getValue()).profile(((PropertiesKey)inputProperties.getKey()).profile()).build();
    }

    public static JHipsterModuleBuilder moduleBuilder(JHipsterModuleProperties properties) {
        return new JHipsterModuleBuilder(properties);
    }

    public static JavaDependency.JavaDependencyGroupIdBuilder javaDependency() {
        return JavaDependency.builder();
    }

    public static JavaDependencyVersion javaDependencyVersion(String slug, String version) {
        return new JavaDependencyVersion(slug, version);
    }

    public static DependencyId dependencyId(String groupId, String artifactId) {
        return new DependencyId(JHipsterModule.groupId(groupId), JHipsterModule.artifactId(artifactId), Optional.empty());
    }

    public static JavaBuildPlugin.JavaBuildPluginGroupIdBuilder javaBuildPlugin() {
        return JavaBuildPlugin.builder();
    }

    public static JHipsterSource from(String source) {
        Assert.notBlank("source", source);
        return new JHipsterSource(Paths.get("/generator", source));
    }

    public static JHipsterProjectFilePath path(String path) {
        return new JHipsterProjectFilePath(path);
    }

    public static JHipsterDestination to(String destination) {
        return new JHipsterDestination(destination);
    }

    public static JHipsterDestination toSrcMainJava() {
        return JHipsterDestination.SRC_MAIN_JAVA;
    }

    public static JHipsterDestination toSrcMainDocker() {
        return JHipsterDestination.SRC_MAIN_DOCKER;
    }

    public static JHipsterDestination toSrcTestJava() {
        return JHipsterDestination.SRC_TEST_JAVA;
    }

    public static GroupId groupId(String groupId) {
        return new GroupId(groupId);
    }

    public static ArtifactId artifactId(String artifactId) {
        return new ArtifactId(artifactId);
    }

    public static VersionSlug versionSlug(String versionSlug) {
        return new VersionSlug(versionSlug);
    }

    public static TextReplacer text(String text) {
        return new TextReplacer(ReplacementCondition.always(), text);
    }

    public static RegexReplacer regex(String regex) {
        return new RegexReplacer(ReplacementCondition.always(), regex);
    }

    public static FileStartReplacer fileStart() {
        return new FileStartReplacer(ReplacementCondition.notContainingReplacement());
    }

    public static TextNeedleBeforeReplacer lineBeforeText(String needle) {
        return new TextNeedleBeforeReplacer(ReplacementCondition.notContainingReplacement(), needle);
    }

    public static RegexNeedleBeforeReplacer lineBeforeRegex(String regex) {
        return new RegexNeedleBeforeReplacer(ReplacementCondition.notContainingReplacement(), Pattern.compile(regex, 8));
    }

    public static RegexNeedleAfterReplacer lineAfterRegex(String regex) {
        return new RegexNeedleAfterReplacer(ReplacementCondition.notContainingReplacement(), Pattern.compile(regex, 8));
    }

    public static PropertyKey propertyKey(String key) {
        return new PropertyKey(key);
    }

    public static PropertyValue propertyValue(String ... values) {
        return new PropertyValue(values);
    }

    public static SpringProfile springProfile(String profile) {
        return new SpringProfile(profile);
    }

    public static DocumentationTitle documentationTitle(String title) {
        return new DocumentationTitle(title);
    }

    public static LocalEnvironment localEnvironment(String localEnvironment) {
        return new LocalEnvironment(localEnvironment);
    }

    public static ScriptKey scriptKey(String key) {
        return new ScriptKey(key);
    }

    public static ScriptCommand scriptCommand(String command) {
        return new ScriptCommand(command);
    }

    public static PackageName packageName(String packageName) {
        return new PackageName(packageName);
    }

    public JHipsterProjectFolder projectFolder() {
        return this.properties.projectFolder();
    }

    public JHipsterModuleProperties properties() {
        return this.properties;
    }

    public Indentation indentation() {
        return this.properties.indentation();
    }

    public JHipsterTemplatedFiles templatedFiles() {
        List<JHipsterTemplatedFile> templatedFiles = this.files.filesToAdd().stream().map(file -> JHipsterTemplatedFile.builder().file((JHipsterModuleFile)file).context(this.context).build()).toList();
        return new JHipsterTemplatedFiles(templatedFiles);
    }

    public JHipsterFilesToMove filesToMove() {
        return this.files.filesToMove();
    }

    public JHipsterFilesToDelete filesToDelete() {
        return this.files.filesToDelete();
    }

    public JHipsterModuleMandatoryReplacements mandatoryReplacements() {
        return this.mandatoryReplacements;
    }

    public JHipsterModuleOptionalReplacements optionalReplacements() {
        return this.optionalReplacements;
    }

    public JHipsterModuleJavaDependencies javaDependencies() {
        return this.javaDependencies;
    }

    public JHipsterModuleJavaBuildPlugin javaBuildPlugins() {
        return this.javaBuildPlugins;
    }

    public JHipsterModulePackageJson packageJson() {
        return this.packageJson;
    }

    public JHipsterModulePreActions preActions() {
        return this.preActions;
    }

    public JHipsterModulePostActions postActions() {
        return this.postActions;
    }

    public SpringProperties springProperties() {
        return this.springProperties;
    }

    public static class JHipsterModuleBuilder {
        private static final String PROFILE = "profile";
        private final JHipsterModuleShortcuts shortcuts;
        private final JHipsterModuleProperties properties;
        private final JHipsterModuleContext.JHipsterModuleContextBuilder context;
        private final JHipsterModuleFiles.JHipsterModuleFilesBuilder files = JHipsterModuleFiles.builder(this);
        private final JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder mandatoryReplacements = JHipsterModuleMandatoryReplacements.builder(this);
        private final JHipsterModuleOptionalReplacements.JHipsterModuleOptionalReplacementsBuilder optionalReplacements = JHipsterModuleOptionalReplacements.builder(this);
        private final JHipsterModuleJavaDependencies.JHipsterModuleJavaDependenciesBuilder javaDependencies = JHipsterModuleJavaDependencies.builder(this);
        private final JHipsterModuleJavaBuildPlugin.JHipsterModuleJavaBuildPluginBuilder javaBuildPlugins = JHipsterModuleJavaBuildPlugin.builder(this);
        private final JHipsterModulePackageJson.JHipsterModulePackageJsonBuilder packageJson = JHipsterModulePackageJson.builder(this);
        private final JHipsterModulePreActions.JHipsterModulePreActionsBuilder preActions = JHipsterModulePreActions.builder(this);
        private final JHipsterModulePostActions.JHipsterModulePostActionsBuilder postActions = JHipsterModulePostActions.builder(this);
        private final Map<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder> springProperties = new HashMap<PropertiesKey, JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder>();

        private JHipsterModuleBuilder(JHipsterModuleProperties properties) {
            Assert.notNull("properties", properties);
            this.properties = properties;
            this.context = JHipsterModuleContext.builder(this);
            this.shortcuts = new JHipsterModuleShortcuts(this);
        }

        JHipsterModuleProperties properties() {
            return this.properties;
        }

        public JHipsterModuleBuilder documentation(DocumentationTitle title, JHipsterSource source) {
            this.shortcuts.documentation(title, source);
            return this;
        }

        public JHipsterModuleBuilder localEnvironment(LocalEnvironment localEnvironment) {
            this.shortcuts.localEnvironment(localEnvironment);
            return this;
        }

        public JHipsterModuleBuilder startupCommand(String startupCommand) {
            this.shortcuts.startupCommand(startupCommand);
            return this;
        }

        public JHipsterModuleContext.JHipsterModuleContextBuilder context() {
            return this.context;
        }

        public JHipsterModuleFiles.JHipsterModuleFilesBuilder files() {
            return this.files;
        }

        public JHipsterModuleMandatoryReplacements.JHipsterModuleMandatoryReplacementsBuilder mandatoryReplacements() {
            return this.mandatoryReplacements;
        }

        public JHipsterModuleBuilder springTestLogger(String name, LogLevel level) {
            this.shortcuts.springTestLogger(name, level);
            return this;
        }

        public JHipsterModuleBuilder springMainLogger(String name, LogLevel level) {
            this.shortcuts.springMainLogger(name, level);
            return this;
        }

        public JHipsterModuleBuilder integrationTestExtension(String extensionClass) {
            this.shortcuts.integrationTestExtension(extensionClass);
            return this;
        }

        public JHipsterModuleOptionalReplacements.JHipsterModuleOptionalReplacementsBuilder optionalReplacements() {
            return this.optionalReplacements;
        }

        public JHipsterModuleJavaDependencies.JHipsterModuleJavaDependenciesBuilder javaDependencies() {
            return this.javaDependencies;
        }

        public JHipsterModuleJavaBuildPlugin.JHipsterModuleJavaBuildPluginBuilder javaBuildPlugins() {
            return this.javaBuildPlugins;
        }

        public JHipsterModulePackageJson.JHipsterModulePackageJsonBuilder packageJson() {
            return this.packageJson;
        }

        public JHipsterModulePreActions.JHipsterModulePreActionsBuilder preActions() {
            return this.preActions;
        }

        public JHipsterModulePostActions.JHipsterModulePostActionsBuilder postActions() {
            return this.postActions;
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springMainProperties() {
            return this.springMainProperties(SpringProfile.DEFAULT);
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springMainBootstrapProperties() {
            return this.springMainBootstrapProperties(SpringProfile.DEFAULT);
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springMainBootstrapProperties(SpringProfile profile) {
            Assert.notNull(PROFILE, profile);
            return this.springProperties.computeIfAbsent(new PropertiesKey(profile, SpringPropertyType.MAIN_BOOTSTRAP_PROPERTIES), key -> JHipsterModuleSpringProperties.builder(this));
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springMainProperties(SpringProfile profile) {
            Assert.notNull(PROFILE, profile);
            return this.springProperties.computeIfAbsent(new PropertiesKey(profile, SpringPropertyType.MAIN_PROPERTIES), key -> JHipsterModuleSpringProperties.builder(this));
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springTestProperties() {
            return this.springTestProperties(SpringProfile.DEFAULT);
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springTestBootstrapProperties() {
            return this.springProperties.computeIfAbsent(new PropertiesKey(SpringProfile.DEFAULT, SpringPropertyType.TEST_BOOTSTRAP_PROPERTIES), key -> JHipsterModuleSpringProperties.builder(this));
        }

        public JHipsterModuleSpringProperties.JHipsterModuleSpringPropertiesBuilder springTestProperties(SpringProfile profile) {
            Assert.notNull(PROFILE, profile);
            return this.springProperties.computeIfAbsent(new PropertiesKey(profile, SpringPropertyType.TEST_PROPERTIES), key -> JHipsterModuleSpringProperties.builder(this));
        }

        String packagePath() {
            return this.properties.basePackage().path();
        }

        Indentation indentation() {
            return this.properties.indentation();
        }

        public JHipsterModule build() {
            return new JHipsterModule(this);
        }
    }

    private record PropertiesKey(SpringProfile profile, SpringPropertyType type) {
    }
}

