/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.file;

import java.nio.file.Path;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModuleContext;
import tech.jhipster.lite.module.domain.ProjectFilesReader;
import tech.jhipster.lite.module.domain.file.JHipsterModuleFile;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;

public class JHipsterTemplatedFile {
    private final JHipsterModuleFile file;
    private final JHipsterModuleContext context;

    private JHipsterTemplatedFile(TemplatedFileBuilder builder) {
        Assert.notNull("file", builder.file);
        Assert.notNull("context", builder.context);
        this.file = builder.file;
        this.context = builder.context;
    }

    public static TemplatedFileBuilder builder() {
        return new TemplatedFileBuilder();
    }

    public Path folder(JHipsterProjectFolder projectFolder) {
        Assert.notNull("projectFolder", projectFolder);
        return this.file.destination().folder(projectFolder);
    }

    public Path path(JHipsterProjectFolder projectFolder) {
        Assert.notNull("projectFolder", projectFolder);
        return this.file.destination().pathInProject(projectFolder);
    }

    public byte[] content(ProjectFilesReader files) {
        return this.file.content().read(files, this.context);
    }

    public boolean isNotExecutable() {
        return !this.file.executable();
    }

    public static class TemplatedFileBuilder {
        private JHipsterModuleFile file;
        private JHipsterModuleContext context;

        public TemplatedFileBuilder file(JHipsterModuleFile file) {
            this.file = file;
            return this;
        }

        public TemplatedFileBuilder context(JHipsterModuleContext context) {
            this.context = context;
            return this;
        }

        public JHipsterTemplatedFile build() {
            return new JHipsterTemplatedFile(this);
        }
    }
}

