/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javabuildplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuild.command.AddBuildPluginManagement;
import tech.jhipster.lite.module.domain.javabuild.command.AddDirectJavaBuildPlugin;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.javabuildplugin.JavaBuildPlugin;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;

public class JHipsterModuleJavaBuildPlugin {
    private final Collection<JavaBuildPlugin> pluginsManagement;
    private final Collection<JavaBuildPlugin> plugins;

    private JHipsterModuleJavaBuildPlugin(JHipsterModuleJavaBuildPluginBuilder builder) {
        this.pluginsManagement = builder.pluginsManagement;
        this.plugins = builder.plugins;
    }

    public static JHipsterModuleJavaBuildPluginBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleJavaBuildPluginBuilder(module);
    }

    public JavaBuildCommands buildChanges(JavaDependenciesVersions versions) {
        Assert.notNull("versions", versions);
        Stream<JavaBuildCommand> managementCommands = this.pluginsManagement.stream().flatMap(JHipsterModuleJavaBuildPlugin.toCommands(versions, AddBuildPluginManagement::new));
        Stream<JavaBuildCommand> pluginsCommands = this.plugins.stream().flatMap(JHipsterModuleJavaBuildPlugin.toCommands(versions, AddDirectJavaBuildPlugin::new));
        return new JavaBuildCommands(Stream.concat(managementCommands, pluginsCommands).toList());
    }

    private static Function<JavaBuildPlugin, Stream<JavaBuildCommand>> toCommands(JavaDependenciesVersions versions, Function<JavaBuildPlugin, JavaBuildCommand> addCommandFactory) {
        return plugin -> {
            JavaBuildCommand addPluginCommand = (JavaBuildCommand)addCommandFactory.apply((JavaBuildPlugin)plugin);
            return plugin.versionSlug().map(version -> Stream.of(new SetVersion(versions.get((VersionSlug)version)), addPluginCommand)).orElseGet(() -> Stream.of(addPluginCommand));
        };
    }

    public static class JHipsterModuleJavaBuildPluginBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Collection<JavaBuildPlugin> pluginsManagement = new ArrayList<JavaBuildPlugin>();
        private final Collection<JavaBuildPlugin> plugins = new ArrayList<JavaBuildPlugin>();

        private JHipsterModuleJavaBuildPluginBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModuleJavaBuildPluginBuilder pluginManagement(JavaBuildPlugin pluginManagement) {
            Assert.notNull("pluginManagement", pluginManagement);
            this.pluginsManagement.add(pluginManagement);
            return this;
        }

        public JHipsterModuleJavaBuildPluginBuilder plugin(JavaBuildPlugin plugin) {
            Assert.notNull("plugin", plugin);
            this.plugins.add(plugin);
            return this;
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModuleJavaBuildPlugin build() {
            return new JHipsterModuleJavaBuildPlugin(this);
        }
    }
}

