/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javadependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javabuild.command.RemoveDirectJavaDependency;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.DirectJavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyManagement;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.javadependency.ProjectJavaDependencies;

public class JHipsterModuleJavaDependencies {
    private final Collection<JavaDependencyVersion> versions;
    private final Collection<DependencyId> dependenciesToRemove;
    private final Collection<JavaDependencyManagement> dependenciesManagement;
    private final Collection<DirectJavaDependency> dependencies;

    private JHipsterModuleJavaDependencies(JHipsterModuleJavaDependenciesBuilder builder) {
        this.versions = builder.versions;
        this.dependenciesToRemove = builder.dependenciesToRemove;
        this.dependenciesManagement = builder.dependenciesManagement;
        this.dependencies = builder.dependencies;
    }

    public static JHipsterModuleJavaDependenciesBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleJavaDependenciesBuilder(module);
    }

    public JavaBuildCommands buildChanges(JavaDependenciesVersions versions, ProjectJavaDependencies projectDependencies) {
        Assert.notNull("versions", versions);
        Assert.notNull("projectDependencies", projectDependencies);
        return Stream.of(this.settedVersionsCommands(), this.dependenciesToRemoveCommands(), this.dependenciesManagementChanges(versions, projectDependencies), this.dependenciesChanges(versions, projectDependencies)).flatMap(Function.identity()).reduce(JavaBuildCommands.EMPTY, JavaBuildCommands::merge);
    }

    private Stream<JavaBuildCommands> settedVersionsCommands() {
        return Stream.of(new JavaBuildCommands(this.versions.stream().map(this.toSetVersionCommand()).toList()));
    }

    private Function<JavaDependencyVersion, JavaBuildCommand> toSetVersionCommand() {
        return SetVersion::new;
    }

    private Stream<JavaBuildCommands> dependenciesToRemoveCommands() {
        return Stream.of(new JavaBuildCommands(this.dependenciesToRemove.stream().map(this.toDependencyToRemove()).toList()));
    }

    private Function<DependencyId, JavaBuildCommand> toDependencyToRemove() {
        return RemoveDirectJavaDependency::new;
    }

    private Stream<JavaBuildCommands> dependenciesManagementChanges(JavaDependenciesVersions currentVersions, ProjectJavaDependencies projectDependencies) {
        return this.dependenciesManagement.stream().map(dependency -> dependency.changeCommands(currentVersions, projectDependencies));
    }

    private Stream<JavaBuildCommands> dependenciesChanges(JavaDependenciesVersions currentVersions, ProjectJavaDependencies projectDependencies) {
        return this.dependencies.stream().map(dependency -> dependency.changeCommands(currentVersions, projectDependencies));
    }

    public static class JHipsterModuleJavaDependenciesBuilder {
        private static final String DEPENDENCY = "dependency";
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Collection<JavaDependencyVersion> versions = new ArrayList<JavaDependencyVersion>();
        private final Collection<DependencyId> dependenciesToRemove = new ArrayList<DependencyId>();
        private final Collection<DirectJavaDependency> dependencies = new ArrayList<DirectJavaDependency>();
        private final Collection<JavaDependencyManagement> dependenciesManagement = new ArrayList<JavaDependencyManagement>();

        private JHipsterModuleJavaDependenciesBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModuleJavaDependenciesBuilder removeDependency(DependencyId dependency) {
            Assert.notNull(DEPENDENCY, dependency);
            this.dependenciesToRemove.add(dependency);
            return this;
        }

        public JHipsterModuleJavaDependenciesBuilder addDependency(GroupId groupId, ArtifactId artifactId) {
            return this.addDependency(groupId, artifactId, null);
        }

        public JHipsterModuleJavaDependenciesBuilder addDependency(GroupId groupId, ArtifactId artifactId, VersionSlug versionSlug) {
            JavaDependency dependency = JavaDependency.builder().groupId(groupId).artifactId(artifactId).versionSlug(versionSlug).build();
            return this.addDependency(dependency);
        }

        public JHipsterModuleJavaDependenciesBuilder addDependency(JavaDependency dependency) {
            Assert.notNull(DEPENDENCY, dependency);
            this.dependencies.add(new DirectJavaDependency(dependency));
            return this;
        }

        public JHipsterModuleJavaDependenciesBuilder setVersion(JavaDependencyVersion version) {
            Assert.notNull("version", version);
            this.versions.add(version);
            return this;
        }

        public JHipsterModuleJavaDependenciesBuilder addDependencyManagement(JavaDependency dependency) {
            Assert.notNull(DEPENDENCY, dependency);
            this.dependenciesManagement.add(new JavaDependencyManagement(dependency));
            return this;
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModuleJavaDependencies build() {
            return new JHipsterModuleJavaDependencies(this);
        }
    }
}

