/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javaproperties;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javaproperties.SpringProfile;
import tech.jhipster.lite.module.domain.javaproperties.SpringPropertyType;

public class SpringProperty {
    private final SpringPropertyType type;
    private final PropertyKey key;
    private final PropertyValue value;
    private final SpringProfile profile;

    private SpringProperty(SpringPropertyBuilder builder) {
        Assert.notNull("key", builder.key);
        Assert.notNull("value", builder.value);
        this.type = builder.type;
        this.key = builder.key;
        this.value = builder.value;
        this.profile = this.buildProfile(builder.profile);
    }

    private SpringProfile buildProfile(SpringProfile profile) {
        if (profile == null) {
            return SpringProfile.DEFAULT;
        }
        return profile;
    }

    public static SpringPropertyBuilder builder(SpringPropertyType type) {
        return new SpringPropertyBuilder(type);
    }

    public SpringPropertyType type() {
        return this.type;
    }

    public PropertyKey key() {
        return this.key;
    }

    public PropertyValue value() {
        return this.value;
    }

    public String filename() {
        if (this.profile.isDefault()) {
            return this.type.filePrefix();
        }
        return this.type.filePrefix() + "-" + this.profile.get();
    }

    public static class SpringPropertyBuilder
    implements SpringPropertyKeyBuilder,
    SpringPropertyValueBuilder,
    SpringPropertyProfileBuilder {
        private final SpringPropertyType type;
        private PropertyKey key;
        private PropertyValue value;
        private SpringProfile profile;

        private SpringPropertyBuilder(SpringPropertyType type) {
            Assert.notNull("type", (Object)type);
            this.type = type;
        }

        @Override
        public SpringPropertyValueBuilder key(PropertyKey key) {
            this.key = key;
            return this;
        }

        @Override
        public SpringPropertyProfileBuilder value(PropertyValue value) {
            this.value = value;
            return this;
        }

        @Override
        public SpringPropertyProfileBuilder profile(SpringProfile profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public SpringProperty build() {
            return new SpringProperty(this);
        }
    }

    public static interface SpringPropertyProfileBuilder {
        public SpringPropertyProfileBuilder profile(SpringProfile var1);

        public SpringProperty build();
    }

    public static interface SpringPropertyValueBuilder {
        public SpringPropertyProfileBuilder value(PropertyValue var1);
    }

    public static interface SpringPropertyKeyBuilder {
        public SpringPropertyValueBuilder key(PropertyKey var1);
    }
}

